/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.OutgoingBatches;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.MaxRowsStatementCreator;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingBatchService
extends AbstractService
implements IOutgoingBatchService {
    private INodeService nodeService;
    private IConfigurationService configurationService;

    @Override
    @Transactional
    public void markAllAsSentForNode(Node node) {
        OutgoingBatches batches = null;
        do {
            batches = this.getOutgoingBatches(node);
            for (OutgoingBatch outgoingBatch : batches.getBatches()) {
                outgoingBatch.setStatus(OutgoingBatch.Status.OK);
                this.updateOutgoingBatch(outgoingBatch);
            }
        } while (batches.getBatches().size() > 0);
    }

    @Override
    public void updateAbandonedRoutingBatches() {
        this.jdbcTemplate.update(this.getSql("updateOutgoingBatchesStatusSql"), new Object[]{OutgoingBatch.Status.NE.name(), OutgoingBatch.Status.RT.name()});
    }

    @Override
    public void updateOutgoingBatch(OutgoingBatch outgoingBatch) {
        this.updateOutgoingBatch(this.jdbcTemplate, outgoingBatch);
    }

    @Override
    public void updateOutgoingBatches(List<OutgoingBatch> outgoingBatches) {
        for (OutgoingBatch batch : outgoingBatches) {
            this.updateOutgoingBatch(this.jdbcTemplate, batch);
        }
    }

    @Override
    public void updateOutgoingBatch(JdbcTemplate template, OutgoingBatch outgoingBatch) {
        outgoingBatch.setLastUpdatedTime(new Date());
        outgoingBatch.setLastUpdatedHostName(AppUtils.getServerId());
        template.update(this.getSql("updateOutgoingBatchSql"), new Object[]{outgoingBatch.getStatus().name(), outgoingBatch.getByteCount(), outgoingBatch.getSentCount(), outgoingBatch.getDataEventCount(), outgoingBatch.getRouterMillis(), outgoingBatch.getNetworkMillis(), outgoingBatch.getFilterMillis(), outgoingBatch.getLoadMillis(), outgoingBatch.getExtractMillis(), outgoingBatch.getSqlState(), outgoingBatch.getSqlCode(), StringUtils.abbreviate((String)outgoingBatch.getSqlMessage(), (int)1000), outgoingBatch.getFailedDataId(), outgoingBatch.getLastUpdatedHostName(), outgoingBatch.getLastUpdatedTime(), outgoingBatch.getBatchId()}, new int[]{1, 2, 2, 2, 2, 2, 2, 2, 2, 12, 2, 12, 2, 12, 93, 2});
    }

    @Override
    public void insertOutgoingBatch(OutgoingBatch outgoingBatch) {
        this.insertOutgoingBatch(this.jdbcTemplate, outgoingBatch);
    }

    @Override
    public void insertOutgoingBatch(JdbcTemplate jdbcTemplate, final OutgoingBatch outgoingBatch) {
        outgoingBatch.setLastUpdatedTime(new Date());
        outgoingBatch.setLastUpdatedHostName(AppUtils.getServerId());
        long batchId = this.dbDialect.insertWithGeneratedKey(jdbcTemplate, this.getSql("insertOutgoingBatchSql"), SequenceIdentifier.OUTGOING_BATCH, new PreparedStatementCallback<Object>(){

            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ps.setString(1, outgoingBatch.getNodeId());
                ps.setString(2, outgoingBatch.getChannelId());
                ps.setString(3, outgoingBatch.getStatus().name());
                ps.setString(4, outgoingBatch.getLastUpdatedHostName());
                ps.setTimestamp(5, new Timestamp(outgoingBatch.getLastUpdatedTime().getTime()));
                return null;
            }
        });
        outgoingBatch.setBatchId(batchId);
    }

    @Override
    public OutgoingBatch findOutgoingBatch(long batchId) {
        List list = this.jdbcTemplate.query(this.getSql("findOutgoingBatchSql"), new Object[]{batchId}, new int[]{2}, (RowMapper)new OutgoingBatchMapper());
        if (list != null && list.size() > 0) {
            return (OutgoingBatch)list.get(0);
        }
        return null;
    }

    @Override
    public int countOutgoingBatchesWithStatus(OutgoingBatch.Status status) {
        return this.jdbcTemplate.queryForInt(this.getSql("countOutgoingBatchesSql"), new Object[]{status.name()});
    }

    @Override
    public OutgoingBatches getOutgoingBatches(Node node) {
        List list = this.jdbcTemplate.query(this.getSql("selectOutgoingBatchSql"), new Object[]{node.getNodeId(), OutgoingBatch.Status.NE.toString(), OutgoingBatch.Status.SE.toString(), OutgoingBatch.Status.ER.toString()}, (RowMapper)new OutgoingBatchMapper());
        OutgoingBatches batches = new OutgoingBatches(list);
        List<NodeChannel> channels = this.configurationService.getNodeChannels(node.getNodeId());
        batches.sortChannels(channels);
        ArrayList<OutgoingBatch> keepers = new ArrayList<OutgoingBatch>();
        for (NodeChannel channel : channels) {
            if (!this.parameterService.is("dataextractor.enable") && !channel.getChannelId().equals("config")) continue;
            keepers.addAll(batches.getBatchesForChannelWindows(node, channel, this.configurationService.getNodeGroupChannelWindows(this.parameterService.getNodeGroupId(), channel.getChannelId())));
        }
        batches.setBatches(keepers);
        return batches;
    }

    @Override
    public OutgoingBatches getOutgoingBatchRange(String startBatchId, String endBatchId) {
        OutgoingBatches batches = new OutgoingBatches();
        batches.setBatches(this.jdbcTemplate.query(this.getSql("selectOutgoingBatchRangeSql"), new Object[]{startBatchId, endBatchId}, (RowMapper)new OutgoingBatchMapper()));
        return batches;
    }

    @Override
    public OutgoingBatches getOutgoingBatchErrors(int maxRows) {
        OutgoingBatches batches = new OutgoingBatches();
        batches.setBatches(this.jdbcTemplate.query((PreparedStatementCreator)new MaxRowsStatementCreator(this.getSql("selectOutgoingBatchErrorsSql"), maxRows), (RowMapper)new OutgoingBatchMapper()));
        return batches;
    }

    @Override
    public boolean isInitialLoadComplete(String nodeId) {
        NodeSecurity security = this.nodeService.findNodeSecurity(nodeId);
        if (security == null || security.isInitialLoadEnabled()) {
            return false;
        }
        List statuses = this.jdbcTemplate.queryForList(this.getSql("initialLoadStatusSql"), new Object[]{nodeId, "reload"}, String.class);
        if (statuses == null || statuses.size() == 0) {
            throw new RuntimeException("The initial load has not been started for " + nodeId);
        }
        for (String status : statuses) {
            if (OutgoingBatch.Status.OK.name().equals(status)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnsentDataOnChannelForNode(String channelId, String nodeId) {
        int unsentCount = this.jdbcTemplate.queryForInt(this.getSql("unsentBatchesForNodeIdChannelIdSql"), new Object[]{nodeId, channelId});
        return unsentCount > 0;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OutgoingBatchMapper
    implements RowMapper<OutgoingBatch> {
        OutgoingBatchMapper() {
        }

        public OutgoingBatch mapRow(ResultSet rs, int num) throws SQLException {
            OutgoingBatch batch = new OutgoingBatch();
            batch.setNodeId(rs.getString(1));
            batch.setChannelId(rs.getString(2));
            batch.setStatus(rs.getString(3));
            batch.setByteCount(rs.getLong(4));
            batch.setSentCount(rs.getLong(5));
            batch.setDataEventCount(rs.getLong(6));
            batch.setRouterMillis(rs.getLong(7));
            batch.setNetworkMillis(rs.getLong(8));
            batch.setFilterMillis(rs.getLong(9));
            batch.setLoadMillis(rs.getLong(10));
            batch.setExtractMillis(rs.getLong(11));
            batch.setSqlState(rs.getString(12));
            batch.setSqlCode(rs.getInt(13));
            batch.setSqlMessage(rs.getString(14));
            batch.setFailedDataId(rs.getLong(15));
            batch.setLastUpdatedHostName(rs.getString(16));
            batch.setLastUpdatedTime(rs.getTimestamp(17));
            batch.setCreateTime(rs.getTimestamp(18));
            batch.setBatchId(rs.getLong(19));
            return batch;
        }
    }
}

