/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.config.INodeIdGenerator;
import org.jumpmind.symmetric.ext.IOfflineServerListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.NodeHost;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.NodeStatus;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeService
extends AbstractService
implements INodeService {
    private Node cachedNodeIdentity;
    private Map<String, NodeSecurity> securityCache;
    private long securityCacheTime;
    private INodeIdGenerator nodeIdGenerator;
    private INodePasswordFilter nodePasswordFilter;
    private NodeHost nodeHostForCurrentNode = null;
    private long offlineNodeDetectionMinutes;
    private List<IOfflineServerListener> offlineServerListeners;

    @Override
    public String findSymmetricVersion() {
        try {
            return (String)this.jdbcTemplate.queryForObject(this.getSql("findSymmetricVersionSql"), String.class);
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    @Override
    public String findIdentityNodeId() {
        Node node = this.findIdentity();
        return node != null ? node.getNodeId() : null;
    }

    @Override
    public Collection<Node> findEnabledNodesFromNodeGroup(String nodeGroupId) {
        return this.jdbcTemplate.query(String.format("%s%s", this.getSqlPrefix("selectNodePrefixSql"), this.getSql("findEnabledNodesFromNodeGroupSql")), new Object[]{nodeGroupId}, (RowMapper)new NodeRowMapper());
    }

    @Override
    public Set<Node> findNodesThatOriginatedFromNodeId(String originalNodeId) {
        HashSet<Node> all = new HashSet<Node>();
        List list = this.jdbcTemplate.query(String.format("%s%s", this.getSqlPrefix("selectNodePrefixSql"), this.getSql("findNodesCreatedByMeSql")), new Object[]{originalNodeId}, (RowMapper)new NodeRowMapper());
        if (list.size() > 0) {
            all.addAll(list);
            for (Node node : list) {
                all.addAll(this.findNodesThatOriginatedFromNodeId(node.getNodeId()));
            }
        }
        return all;
    }

    @Override
    public Node findNode(String id) {
        List list = this.jdbcTemplate.query(this.getSqlPrefix("selectNodePrefixSql") + this.getSql("findNodeSql"), new Object[]{id}, (RowMapper)new NodeRowMapper());
        return (Node)this.getFirstEntry(list);
    }

    @Override
    public Node findNodeByExternalId(String nodeGroupId, String externalId) {
        List list = this.jdbcTemplate.query(this.getSqlPrefix("selectNodePrefixSql") + this.getSql("findNodeByExternalIdSql"), new Object[]{nodeGroupId, externalId}, (RowMapper)new NodeRowMapper());
        return (Node)this.getFirstEntry(list);
    }

    @Override
    public void ignoreNodeChannelForExternalId(boolean enabled, String channelId, String nodeGroupId, String externalId) {
        Node node = this.findNodeByExternalId(nodeGroupId, externalId);
        if (this.jdbcTemplate.update(this.getSql("nodeChannelControlIgnoreSql"), new Object[]{enabled ? 1 : 0, node.getNodeId(), channelId}) == 0) {
            this.jdbcTemplate.update(this.getSql("insertNodeChannelControlSql"), new Object[]{node.getNodeId(), channelId, enabled ? 1 : 0, 0});
        }
    }

    @Override
    public boolean isRegistrationEnabled(String nodeId) {
        NodeSecurity nodeSecurity = this.findNodeSecurity(nodeId);
        if (nodeSecurity != null) {
            return nodeSecurity.isRegistrationEnabled();
        }
        return false;
    }

    @Override
    public NodeSecurity findNodeSecurity(String id) {
        return this.findNodeSecurity(id, false);
    }

    @Override
    public void updateNodeHostForCurrentNode() {
        if (this.nodeHostForCurrentNode == null) {
            this.nodeHostForCurrentNode = new NodeHost(this.findIdentityNodeId());
        }
        this.nodeHostForCurrentNode.refresh();
        Object[] params = new Object[]{this.nodeHostForCurrentNode.getIpAddress(), this.nodeHostForCurrentNode.getOsUser(), this.nodeHostForCurrentNode.getOsName(), this.nodeHostForCurrentNode.getOsArch(), this.nodeHostForCurrentNode.getOsVersion(), this.nodeHostForCurrentNode.getAvailableProcessors(), this.nodeHostForCurrentNode.getFreeMemoryBytes(), this.nodeHostForCurrentNode.getTotalMemoryBytes(), this.nodeHostForCurrentNode.getMaxMemoryBytes(), this.nodeHostForCurrentNode.getJavaVersion(), this.nodeHostForCurrentNode.getJavaVendor(), this.nodeHostForCurrentNode.getSymmetricVersion(), this.nodeHostForCurrentNode.getTimezoneOffset(), this.nodeHostForCurrentNode.getHeartbeatTime(), this.nodeHostForCurrentNode.getLastRestartTime(), this.nodeHostForCurrentNode.getNodeId(), this.nodeHostForCurrentNode.getHostName()};
        if (this.jdbcTemplate.update(this.getSql("updateNodeHostSql"), params) == 0) {
            this.jdbcTemplate.update(this.getSql("insertNodeHostSql"), params);
        }
    }

    @Override
    public NodeSecurity findNodeSecurity(String nodeId, boolean createIfNotFound) {
        try {
            if (nodeId != null) {
                List list = this.jdbcTemplate.query(this.getSql("findNodeSecuritySql"), new Object[]{nodeId}, new int[]{12}, (RowMapper)new NodeSecurityRowMapper());
                NodeSecurity security = (NodeSecurity)this.getFirstEntry(list);
                if (security == null && createIfNotFound) {
                    this.insertNodeSecurity(nodeId);
                    security = this.findNodeSecurity(nodeId, false);
                } else if (security != null) {
                    security.setNodePassword(this.filterPasswordOnRenderIfNeeded(security.getNodePassword()));
                }
                return security;
            }
            this.log.debug("FindNodeSecurityNodeNull");
            return null;
        }
        catch (DataIntegrityViolationException ex) {
            this.log.error("NodeSecurityMissing", nodeId);
            throw ex;
        }
    }

    @Override
    public void deleteNodeSecurity(String nodeId) {
        this.jdbcTemplate.update(this.getSql("deleteNodeSecuritySql"), new Object[]{nodeId});
    }

    public void insertNodeSecurity(String id) {
        this.flushNodeAuthorizedCache();
        String password = this.nodeIdGenerator.generatePassword(this, new Node(id, null, null));
        password = this.filterPasswordOnSaveIfNeeded(password);
        this.jdbcTemplate.update(this.getSql("insertNodeSecuritySql"), new Object[]{id, password, this.findIdentity().getNodeId()});
    }

    @Override
    public void insertNodeIdentity(String nodeId) {
        this.jdbcTemplate.update(this.getSql("insertNodeIdentitySql"), new Object[]{nodeId});
    }

    @Override
    public void deleteIdentity() {
        this.jdbcTemplate.execute(this.getSql("deleteNodeIdentitySql"));
        this.cachedNodeIdentity = null;
    }

    @Override
    public void insertNode(String nodeId, String nodeGroupdId, String externalId, String createdAtNodeId) {
        this.jdbcTemplate.update(this.getSql("insertNodeSql"), new Object[]{nodeId, nodeGroupdId, externalId, createdAtNodeId, AppUtils.getTimezoneOffset()});
    }

    @Override
    public void insertNodeGroup(String groupId, String description) {
        if (this.jdbcTemplate.queryForInt(this.getSql("doesNodeGroupExistSql"), new Object[]{groupId}) == 0) {
            this.jdbcTemplate.update(this.getSql("insertNodeGroupSql"), new Object[]{description, groupId});
        }
    }

    @Override
    public boolean updateNode(Node node) {
        boolean updated = this.jdbcTemplate.update(this.getSql("updateNodeSql"), new Object[]{node.getNodeGroupId(), node.getExternalId(), node.getDatabaseType(), node.getDatabaseVersion(), node.getSchemaVersion(), node.getSymmetricVersion(), node.getSyncUrl(), node.getHeartbeatTime(), node.isSyncEnabled() ? 1 : 0, node.getTimezoneOffset(), node.getBatchToSendCount(), node.getBatchInErrorCount(), node.getCreatedAtNodeId(), node.getNodeId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 93, 2, 12, 2, 2, 12, 12}) == 1;
        return updated;
    }

    protected <T> T getFirstEntry(List<T> list) {
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public boolean isNodeAuthorized(String id, String password) {
        NodeSecurity nodeSecurity;
        long maxSecurityCacheTime = this.parameterService.getLong("cache.node.security.time.ms");
        if (System.currentTimeMillis() - this.securityCacheTime >= maxSecurityCacheTime || this.securityCacheTime == 0L) {
            this.securityCache = (Map)this.jdbcTemplate.query(this.getSql("findAllNodeSecuritySql"), (ResultSetExtractor)new NodeSecurityResultSetExtractor());
            this.securityCacheTime = System.currentTimeMillis();
        }
        return (nodeSecurity = this.securityCache.get(id)) != null && (nodeSecurity.getNodePassword() != null && !nodeSecurity.getNodePassword().equals("") && nodeSecurity.getNodePassword().equals(password) || nodeSecurity.isRegistrationEnabled());
    }

    @Override
    public void flushNodeAuthorizedCache() {
        this.securityCacheTime = 0L;
    }

    @Override
    public Node findIdentity() {
        return this.findIdentity(true);
    }

    @Override
    public Node findIdentity(boolean useCache) {
        if (this.cachedNodeIdentity == null || !useCache) {
            List list = this.jdbcTemplate.query(this.getSqlPrefix("selectNodePrefixSql") + this.getSql("findNodeIdentitySql"), (RowMapper)new NodeRowMapper());
            this.cachedNodeIdentity = (Node)this.getFirstEntry(list);
        }
        return this.cachedNodeIdentity;
    }

    @Override
    public List<Node> findNodesToPull() {
        return this.findSourceNodesFor(NodeGroupLinkAction.W);
    }

    @Override
    public List<Node> findNodesToPushTo() {
        return this.findTargetNodesFor(NodeGroupLinkAction.P);
    }

    @Override
    public List<Node> findSourceNodesFor(NodeGroupLinkAction eventAction) {
        Node node = this.findIdentity();
        if (node != null) {
            return this.jdbcTemplate.query(this.getSqlPrefix("selectNodePrefixSql") + this.getSql("findNodesWhoTargetMeSql"), new Object[]{node.getNodeGroupId(), eventAction.name()}, (RowMapper)new NodeRowMapper());
        }
        return Collections.emptyList();
    }

    @Override
    public List<Node> findTargetNodesFor(NodeGroupLinkAction eventAction) {
        Node node = this.findIdentity();
        if (node != null) {
            return this.jdbcTemplate.query(this.getSqlPrefix("selectNodePrefixSql") + this.getSql("findNodesWhoITargetSql"), new Object[]{node.getNodeGroupId(), eventAction.name()}, (RowMapper)new NodeRowMapper());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean updateNodeSecurity(NodeSecurity security) {
        this.flushNodeAuthorizedCache();
        security.setNodePassword(this.filterPasswordOnSaveIfNeeded(security.getNodePassword()));
        return this.jdbcTemplate.update(this.getSql("updateNodeSecuritySql"), new Object[]{security.getNodePassword(), security.isRegistrationEnabled() ? 1 : 0, security.getRegistrationTime(), security.isInitialLoadEnabled() ? 1 : 0, security.getInitialLoadTime(), security.getCreatedAtNodeId(), security.getNodeId()}, new int[]{12, 2, 93, 2, 93, 12, 12}) == 1;
    }

    @Override
    public boolean setInitialLoadEnabled(String nodeId, boolean initialLoadEnabled) {
        NodeSecurity nodeSecurity = this.findNodeSecurity(nodeId, true);
        if (nodeSecurity != null) {
            nodeSecurity.setInitialLoadEnabled(initialLoadEnabled);
            if (initialLoadEnabled) {
                nodeSecurity.setInitialLoadTime(null);
            } else {
                nodeSecurity.setInitialLoadTime(new Date());
            }
            return this.updateNodeSecurity(nodeSecurity);
        }
        return false;
    }

    @Override
    public boolean isExternalIdRegistered(String nodeGroupId, String externalId) {
        return this.jdbcTemplate.queryForInt(this.getSql("isNodeRegisteredSql"), new Object[]{nodeGroupId, externalId}) > 0;
    }

    @Override
    public INodeIdGenerator getNodeIdGenerator() {
        return this.nodeIdGenerator;
    }

    @Override
    public void setNodeIdGenerator(INodeIdGenerator nodeIdGenerator) {
        this.nodeIdGenerator = nodeIdGenerator;
    }

    @Override
    public boolean isDataLoadCompleted() {
        return this.getNodeStatus() == NodeStatus.DATA_LOAD_COMPLETED;
    }

    @Override
    public boolean isDataLoadStarted() {
        return this.getNodeStatus() == NodeStatus.DATA_LOAD_STARTED;
    }

    @Override
    public boolean isRegistrationServer() {
        return StringUtils.isBlank((String)this.parameterService.getRegistrationUrl());
    }

    @Override
    public NodeStatus getNodeStatus() {
        long ts = System.currentTimeMillis();
        try {
            List results = this.jdbcTemplate.query(this.getSql("getDataLoadStatusSql"), new RowMapper(){

                public Object mapRow(ResultSet rs, int arg1) throws SQLException {
                    class DataLoadStatus {
                        int initialLoadEnabled;
                        Date initialLoadTime;

                        DataLoadStatus() {
                        }
                    }
                    DataLoadStatus status = new DataLoadStatus();
                    status.initialLoadEnabled = rs.getInt(1);
                    status.initialLoadTime = rs.getTimestamp(2);
                    return status;
                }
            });
            if (results.size() > 0) {
                DataLoadStatus status = (DataLoadStatus)results.get(0);
                if (status.initialLoadEnabled == 1) {
                    return NodeStatus.DATA_LOAD_STARTED;
                }
                if (status.initialLoadTime != null) {
                    return NodeStatus.DATA_LOAD_COMPLETED;
                }
            }
            return NodeStatus.DATA_LOAD_NOT_STARTED;
        }
        catch (CannotAcquireLockException ex) {
            this.log.error("LockAcquiringFailed", System.currentTimeMillis() - ts);
            return NodeStatus.STATUS_UNKNOWN;
        }
    }

    @Override
    public void setNodePasswordFilter(INodePasswordFilter nodePasswordFilter) {
        this.nodePasswordFilter = nodePasswordFilter;
    }

    private String filterPasswordOnSaveIfNeeded(String password) {
        String s = password;
        if (this.nodePasswordFilter != null) {
            s = this.nodePasswordFilter.onNodeSecuritySave(password);
        }
        return s;
    }

    private String filterPasswordOnRenderIfNeeded(String password) {
        String s = password;
        if (this.nodePasswordFilter != null) {
            s = this.nodePasswordFilter.onNodeSecurityRender(password);
        }
        return s;
    }

    @Override
    public void checkForOfflineNodes() {
        List<Node> list;
        if (this.offlineServerListeners != null && this.getOfflineNodeDetectionMinutes() > 0L && (list = this.findOfflineNodes()).size() > 0) {
            this.fireOffline(list);
        }
    }

    @Override
    public List<Node> findOfflineNodes() {
        ArrayList<Node> offlineNodeList = new ArrayList<Node>();
        Node myNode = this.findIdentity();
        if (myNode != null) {
            long offlineNodeDetectionMillis = this.getOfflineNodeDetectionMinutes() * 60L * 1000L;
            List list = this.jdbcTemplate.query(this.getSqlPrefix("selectNodePrefixSql") + this.getSql("findOfflineNodesSql"), new Object[]{myNode.getNodeId(), myNode.getNodeId()}, (RowMapper)new NodeRowMapper());
            for (Node node : list) {
                Date clientNodeCurrentTime = null;
                clientNodeCurrentTime = node.getTimezoneOffset() != null ? AppUtils.getLocalDateForOffset(node.getTimezoneOffset()) : new Date();
                long cutOffTimeMillis = clientNodeCurrentTime.getTime() - offlineNodeDetectionMillis;
                if (node.getHeartbeatTime() != null && node.getHeartbeatTime().getTime() >= cutOffTimeMillis) continue;
                offlineNodeList.add(node);
            }
        }
        return offlineNodeList;
    }

    public long getOfflineNodeDetectionMinutes() {
        return this.offlineNodeDetectionMinutes;
    }

    public void setOfflineNodeDetectionMinutes(long offlineNodeDetectionMinutes) {
        this.offlineNodeDetectionMinutes = offlineNodeDetectionMinutes;
    }

    public void setOfflineServerListeners(List<IOfflineServerListener> listeners) {
        this.offlineServerListeners = listeners;
    }

    @Override
    public void addOfflineServerListener(IOfflineServerListener listener) {
        if (this.offlineServerListeners == null) {
            this.offlineServerListeners = new ArrayList<IOfflineServerListener>();
        }
        this.offlineServerListeners.add(listener);
    }

    @Override
    public boolean removeOfflineServerListener(IOfflineServerListener listener) {
        if (this.offlineServerListeners != null) {
            return this.offlineServerListeners.remove(listener);
        }
        return false;
    }

    protected void fireOffline(List<Node> offlineClientNodeList) {
        if (this.offlineServerListeners != null) {
            for (IOfflineServerListener listener : this.offlineServerListeners) {
                for (Node node : offlineClientNodeList) {
                    listener.clientNodeOffline(node);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeSecurityResultSetExtractor
    implements ResultSetExtractor<Map<String, NodeSecurity>> {
        NodeSecurityResultSetExtractor() {
        }

        public Map<String, NodeSecurity> extractData(ResultSet rs) throws SQLException, DataAccessException {
            HashMap<String, NodeSecurity> result = new HashMap<String, NodeSecurity>();
            NodeSecurityRowMapper mapper = new NodeSecurityRowMapper();
            while (rs.next()) {
                NodeSecurity nodeSecurity = mapper.mapRow(rs, 0);
                result.put(nodeSecurity.getNodeId(), nodeSecurity);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeSecurityRowMapper
    implements RowMapper<NodeSecurity> {
        NodeSecurityRowMapper() {
        }

        public NodeSecurity mapRow(ResultSet rs, int num) throws SQLException {
            NodeSecurity nodeSecurity = new NodeSecurity();
            nodeSecurity.setNodeId(rs.getString(1));
            nodeSecurity.setNodePassword(rs.getString(2));
            nodeSecurity.setRegistrationEnabled(rs.getBoolean(3));
            nodeSecurity.setRegistrationTime(rs.getTimestamp(4));
            nodeSecurity.setInitialLoadEnabled(rs.getBoolean(5));
            nodeSecurity.setInitialLoadTime(rs.getTimestamp(6));
            nodeSecurity.setCreatedAtNodeId(rs.getString(7));
            return nodeSecurity;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeRowMapper
    implements RowMapper<Node> {
        NodeRowMapper() {
        }

        public Node mapRow(ResultSet rs, int num) throws SQLException {
            Node node = new Node();
            node.setNodeId(rs.getString(1));
            node.setNodeGroupId(rs.getString(2));
            node.setExternalId(rs.getString(3));
            node.setSyncEnabled(rs.getBoolean(4));
            node.setSyncUrl(rs.getString(5));
            node.setSchemaVersion(rs.getString(6));
            node.setDatabaseType(rs.getString(7));
            node.setDatabaseVersion(rs.getString(8));
            node.setSymmetricVersion(rs.getString(9));
            node.setCreatedAtNodeId(rs.getString(10));
            node.setHeartbeatTime(rs.getTimestamp(11));
            node.setTimezoneOffset(rs.getString(12));
            node.setBatchToSendCount(rs.getInt(13));
            node.setBatchInErrorCount(rs.getInt(14));
            return node;
        }
    }
}

