/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.MaxRowsStatementCreator;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingBatchService
extends AbstractService
implements IIncomingBatchService {
    @Override
    public IncomingBatch findIncomingBatch(long batchId, String nodeId) {
        try {
            return (IncomingBatch)this.jdbcTemplate.queryForObject(this.getSql("findIncomingBatchSql"), new Object[]{batchId, nodeId}, (RowMapper)new IncomingBatchMapper());
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<IncomingBatch> findIncomingBatchErrors(int maxRows) {
        return this.jdbcTemplate.query((PreparedStatementCreator)new MaxRowsStatementCreator(this.getSql("findIncomingBatchErrorsSql"), maxRows), (RowMapper)new IncomingBatchMapper());
    }

    @Override
    public boolean acquireIncomingBatch(IncomingBatch batch) {
        boolean okayToProcess = true;
        if (batch.isPersistable()) {
            Object savepoint = this.dbDialect.createSavepointForFallback();
            try {
                this.insertIncomingBatch(batch);
                this.dbDialect.releaseSavepoint(savepoint);
            }
            catch (DataIntegrityViolationException e) {
                this.dbDialect.rollbackToSavepoint(savepoint);
                batch.setRetry(true);
                IncomingBatch existingBatch = this.findIncomingBatch(batch.getBatchId(), batch.getNodeId());
                if (existingBatch.getStatus() == IncomingBatch.Status.ER || !this.parameterService.is("incoming.batches.skip.duplicates")) {
                    okayToProcess = true;
                    this.log.warn("BatchRetrying", batch.getNodeBatchId());
                }
                okayToProcess = false;
                batch.setSkipCount(existingBatch.getSkipCount() + 1L);
                this.log.warn("BatchSkipping", batch.getNodeBatchId());
            }
        }
        return okayToProcess;
    }

    @Override
    public void insertIncomingBatch(IncomingBatch batch) {
        batch.setLastUpdatedHostName(AppUtils.getServerId());
        batch.setLastUpdatedTime(new Date());
        this.jdbcTemplate.update(this.getSql("insertIncomingBatchSql"), new Object[]{batch.getBatchId(), batch.getNodeId(), batch.getChannelId(), batch.getStatus().toString(), batch.getNetworkMillis(), batch.getFilterMillis(), batch.getDatabaseMillis(), batch.getFailedRowNumber(), batch.getByteCount(), batch.getStatementCount(), batch.getFallbackInsertCount(), batch.getFallbackUpdateCount(), batch.getMissingDeleteCount(), batch.getSkipCount(), batch.getSqlState(), batch.getSqlCode(), StringUtils.abbreviate((String)batch.getSqlMessage(), (int)1000), batch.getLastUpdatedHostName(), batch.getLastUpdatedTime()});
    }

    @Override
    public int updateIncomingBatch(IncomingBatch batch) {
        batch.setLastUpdatedHostName(AppUtils.getServerId());
        batch.setLastUpdatedTime(new Date());
        return this.jdbcTemplate.update(this.getSql("updateIncomingBatchSql"), new Object[]{batch.getStatus().toString(), batch.getNetworkMillis(), batch.getFilterMillis(), batch.getDatabaseMillis(), batch.getFailedRowNumber(), batch.getByteCount(), batch.getStatementCount(), batch.getFallbackInsertCount(), batch.getFallbackUpdateCount(), batch.getMissingDeleteCount(), batch.getSkipCount(), batch.getSqlState(), batch.getSqlCode(), StringUtils.abbreviate((String)batch.getSqlMessage(), (int)1000), batch.getLastUpdatedHostName(), batch.getLastUpdatedTime(), batch.getBatchId(), batch.getNodeId()});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IncomingBatchMapper
    implements RowMapper<IncomingBatch> {
        IncomingBatchMapper() {
        }

        public IncomingBatch mapRow(ResultSet rs, int num) throws SQLException {
            IncomingBatch batch = new IncomingBatch();
            batch.setBatchId(rs.getLong(1));
            batch.setNodeId(rs.getString(2));
            batch.setChannelId(rs.getString(3));
            batch.setStatus(IncomingBatch.Status.valueOf(rs.getString(4)));
            batch.setNetworkMillis(rs.getLong(5));
            batch.setFilterMillis(rs.getLong(6));
            batch.setDatabaseMillis(rs.getLong(7));
            batch.setFailedRowNumber(rs.getLong(8));
            batch.setByteCount(rs.getLong(9));
            batch.setStatementCount(rs.getLong(10));
            batch.setFallbackInsertCount(rs.getLong(11));
            batch.setFallbackUpdateCount(rs.getLong(12));
            batch.setMissingDeleteCount(rs.getLong(13));
            batch.setSkipCount(rs.getLong(14));
            batch.setSqlState(rs.getString(15));
            batch.setSqlCode(rs.getInt(16));
            batch.setSqlMessage(rs.getString(17));
            batch.setLastUpdatedHostName(rs.getString(18));
            batch.setLastUpdatedTime(rs.getTimestamp(19));
            batch.setCreateTime(rs.getTimestamp(20));
            return batch;
        }
    }
}

