/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import com.csvreader.CsvWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.Message;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.JdbcBatchPreparedStatementCallback;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.ext.IHeartbeatListener;
import org.jumpmind.symmetric.load.IReloadListener;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEvent;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.DataRef;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.CsvUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataService
extends AbstractService
implements IDataService {
    private ITriggerRouterService triggerRouterService;
    private INodeService nodeService;
    private IPurgeService purgeService;
    private IClusterService clusterService;
    private IConfigurationService configurationService;
    private IOutgoingBatchService outgoingBatchService;
    private List<IReloadListener> reloadListeners;
    private List<IHeartbeatListener> heartbeatListeners;
    protected Map<IHeartbeatListener, Long> lastHeartbeatTimestamps = new HashMap<IHeartbeatListener, Long>();

    @Override
    public void insertReloadEvent(Node targetNode, TriggerRouter triggerRouter) {
        this.insertReloadEvent(targetNode, triggerRouter, null);
    }

    public void insertReloadEvent(Node targetNode, TriggerRouter triggerRouter, String overrideInitialLoadSelect) {
        TriggerHistory history = this.lookupTriggerHistory(triggerRouter.getTrigger());
        Data data = new Data(history.getSourceTableName(), DataEventType.RELOAD, overrideInitialLoadSelect != null ? overrideInitialLoadSelect : triggerRouter.getInitialLoadSelect(), null, history, "reload", null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), triggerRouter.getRouter().getRouterId());
    }

    @Override
    public void insertResendConfigEvent(Node targetNode) {
        Data data = new Data("NA", DataEventType.CONFIG, null, null, null, "config", null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), "?");
    }

    private TriggerHistory lookupTriggerHistory(Trigger trigger) {
        TriggerHistory history = this.triggerRouterService.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
        if (history == null) {
            throw new RuntimeException("Cannot find history for trigger " + trigger.getTriggerId() + ", " + trigger.getSourceTableName());
        }
        return history;
    }

    @Override
    public void insertPurgeEvent(Node targetNode, TriggerRouter triggerRouter) {
        String sql = this.dbDialect.createPurgeSqlFor(targetNode, triggerRouter);
        this.insertSqlEvent(targetNode, triggerRouter.getTrigger(), sql);
    }

    @Override
    public void insertSqlEvent(Node targetNode, Trigger trigger, String sql) {
        TriggerHistory history = this.triggerRouterService.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
        Data data = new Data(trigger.getSourceTableName(), DataEventType.SQL, CsvUtils.escapeCsvData(sql), null, history, "reload", null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), "?");
    }

    @Override
    public void insertSqlEvent(Node targetNode, String sql) {
        Data data = new Data("NA", DataEventType.SQL, CsvUtils.escapeCsvData(sql), null, null, "reload", null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), "?");
    }

    @Override
    public int countDataInRange(long firstDataId, long secondDataId) {
        return this.jdbcTemplate.queryForInt(this.getSql("countDataInRangeSql"), new Object[]{firstDataId, secondDataId});
    }

    @Override
    public void insertCreateEvent(Node targetNode, TriggerRouter triggerRouter, String xml) {
        TriggerHistory history = this.triggerRouterService.getNewestTriggerHistoryForTrigger(triggerRouter.getTrigger().getTriggerId());
        Data data = new Data(triggerRouter.getTrigger().getSourceTableName(), DataEventType.CREATE, CsvUtils.escapeCsvData(xml), null, history, "reload", null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), "?");
    }

    @Override
    public long insertData(final Data data) {
        long id = this.dbDialect.insertWithGeneratedKey(this.getSql("insertIntoDataSql"), SequenceIdentifier.DATA, new PreparedStatementCallback<Object>(){

            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ps.setString(1, data.getTableName());
                ps.setString(2, data.getEventType().getCode());
                ps.setString(3, data.getRowData());
                ps.setString(4, data.getPkData());
                ps.setString(5, data.getOldData());
                ps.setLong(6, data.getTriggerHistory() != null ? (long)data.getTriggerHistory().getTriggerHistoryId() : -1L);
                ps.setString(7, data.getChannelId());
                return null;
            }
        });
        data.setDataId(id);
        return id;
    }

    public void insertDataEvent(DataEvent dataEvent) {
        this.insertDataEvent(this.jdbcTemplate, dataEvent.getDataId(), dataEvent.getBatchId(), dataEvent.getRouterId());
    }

    @Override
    public void insertDataEvent(long dataId, long batchId, String routerId) {
        this.insertDataEvent(this.jdbcTemplate, dataId, batchId, routerId);
    }

    @Override
    public void insertDataEvent(JdbcTemplate template, long dataId, long batchId, String routerId) {
        try {
            template.update(this.getSql("insertIntoDataEventSql"), new Object[]{dataId, batchId, StringUtils.isBlank((String)routerId) ? "?" : routerId}, new int[]{2, 2, 12});
        }
        catch (RuntimeException ex) {
            this.log.error("DataEventInsertFailed", ex, dataId, batchId, routerId);
            throw ex;
        }
    }

    @Override
    public void insertDataEvents(JdbcTemplate template, final List<DataEvent> events) {
        if (events.size() > 0) {
            JdbcBatchPreparedStatementCallback callback = new JdbcBatchPreparedStatementCallback(this.dbDialect, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    DataEvent event = (DataEvent)events.get(i);
                    ps.setLong(1, event.getDataId());
                    ps.setLong(2, event.getBatchId());
                    ps.setString(3, StringUtils.isBlank((String)event.getRouterId()) ? "?" : event.getRouterId());
                }

                public int getBatchSize() {
                    return events.size();
                }
            }, this.parameterService.getInt("db.jdbc.execute.batch.size"));
            template.execute(this.getSql("insertIntoDataEventSql"), (PreparedStatementCallback)callback);
        }
    }

    @Override
    public void insertDataAndDataEventAndOutgoingBatch(Data data, String channelId, List<Node> nodes, String routerId) {
        long dataId = this.insertData(data);
        for (Node node : nodes) {
            this.insertDataEventAndOutgoingBatch(dataId, channelId, node.getNodeId(), routerId);
        }
    }

    @Override
    public void insertDataAndDataEventAndOutgoingBatch(Data data, String nodeId, String routerId) {
        long dataId = this.insertData(data);
        this.insertDataEventAndOutgoingBatch(dataId, data.getChannelId(), nodeId, routerId);
    }

    @Override
    public void insertDataEventAndOutgoingBatch(long dataId, String channelId, String nodeId, String routerId) {
        OutgoingBatch outgoingBatch = new OutgoingBatch(nodeId, channelId, OutgoingBatch.Status.NE);
        this.outgoingBatchService.insertOutgoingBatch(outgoingBatch);
        this.insertDataEvent(new DataEvent(dataId, outgoingBatch.getBatchId(), routerId));
    }

    @Override
    public String reloadNode(String nodeId) {
        Node targetNode = this.nodeService.findNode(nodeId);
        if (targetNode == null) {
            return Message.get("NodeUnknown", nodeId);
        }
        if (this.nodeService.setInitialLoadEnabled(nodeId, true)) {
            return Message.get("NodeInitialLoadOpened", nodeId);
        }
        return Message.get("NodeInitialLoadFailed", nodeId);
    }

    @Override
    public void insertReloadEvent(Node targetNode) {
        this.outgoingBatchService.markAllAsSentForNode(targetNode);
        if (this.parameterService.is("datareload.batch.insert.transactional")) {
            this.newTransactionTemplate.execute((TransactionCallback)new TransactionalInsertReloadEventsDelegate(targetNode));
        } else {
            new TransactionalInsertReloadEventsDelegate(targetNode).doInTransaction(null);
        }
        this.purgeService.purgeAllIncomingEventsForNode(targetNode.getNodeId());
    }

    private void insertNodeSecurityUpdate(Node node, boolean isReload) {
        Data data = this.createData(this.tablePrefix + "_node_security", " t.node_id = '" + node.getNodeId() + "'", isReload);
        if (data != null) {
            this.insertDataAndDataEventAndOutgoingBatch(data, node.getNodeId(), "?");
        }
    }

    @Override
    public void sendScript(String nodeId, String script) {
        Node targetNode = this.nodeService.findNode(nodeId);
        Data data = new Data("NA", DataEventType.BSH, CsvUtils.escapeCsvData(script), null, null, "reload", null, null);
        this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), "?");
    }

    @Override
    public String sendSQL(String nodeId, String tableName, String sql) {
        Node sourceNode = this.nodeService.findIdentity();
        Node targetNode = this.nodeService.findNode(nodeId);
        if (targetNode == null) {
            return "Unknown node " + nodeId;
        }
        TriggerRouter trigger = this.triggerRouterService.findTriggerRouterForCurrentNode(tableName);
        if (trigger == null) {
            return "Trigger for table " + tableName + " does not exist from node " + sourceNode.getNodeGroupId();
        }
        this.insertSqlEvent(targetNode, trigger.getTrigger(), sql);
        return "Successfully create SQL event for node " + targetNode.getNodeId();
    }

    @Override
    public String reloadTable(String nodeId, String tableName) {
        return this.reloadTable(nodeId, tableName, null);
    }

    @Override
    public String reloadTable(String nodeId, String tableName, String overrideInitialLoadSelect) {
        Node sourceNode = this.nodeService.findIdentity();
        Node targetNode = this.nodeService.findNode(nodeId);
        if (targetNode == null) {
            return "Unknown node " + nodeId;
        }
        TriggerRouter triggerRouter = this.triggerRouterService.findTriggerRouterForCurrentNode(tableName);
        if (triggerRouter == null) {
            return "Trigger for table " + tableName + " does not exist from node " + sourceNode.getNodeGroupId();
        }
        if (this.parameterService.is("initial.load.create.first")) {
            String xml = this.dbDialect.getCreateTableXML(triggerRouter);
            this.insertCreateEvent(targetNode, triggerRouter, xml);
        } else if (this.parameterService.is("initial.load.delete.first")) {
            this.insertPurgeEvent(targetNode, triggerRouter);
        }
        this.insertReloadEvent(targetNode, triggerRouter, overrideInitialLoadSelect);
        return "Successfully created event to reload table " + tableName + " for node " + targetNode.getNodeId();
    }

    @Override
    public void insertHeartbeatEvent(Node node, boolean isReload) {
        String tableName = TableConstants.getTableName(this.tablePrefix, "node");
        List<NodeGroupLink> links = this.configurationService.getGroupLinksFor(this.parameterService.getNodeGroupId());
        for (NodeGroupLink nodeGroupLink : links) {
            if (nodeGroupLink.getDataEventAction() != NodeGroupLinkAction.P) continue;
            TriggerRouter triggerRouter = this.triggerRouterService.getTriggerRouterForTableForCurrentNode(nodeGroupLink, tableName, false);
            if (triggerRouter != null) {
                Data data = this.createData(triggerRouter.getTrigger(), String.format(" t.node_id = '%s'", node.getNodeId()), false);
                if (data != null) {
                    this.insertData(data);
                    continue;
                }
                this.log.warn("TableGeneratingEventsFailure", tableName);
                continue;
            }
            this.log.warn("TableGeneratingEventsFailure", tableName);
        }
    }

    @Override
    public Data createData(String tableName, boolean isReload) {
        return this.createData(tableName, null, isReload);
    }

    @Override
    public Data createData(String tableName, String whereClause, boolean isReload) {
        Data data = null;
        TriggerRouter trigger = this.triggerRouterService.getTriggerRouterForTableForCurrentNode(tableName, false);
        if (trigger != null) {
            data = this.createData(trigger.getTrigger(), whereClause, isReload);
        }
        return data;
    }

    public Data createData(Trigger trigger, String whereClause, boolean isReload) {
        Data data = null;
        if (trigger != null) {
            TriggerHistory history;
            String rowData = null;
            String pkData = null;
            if (whereClause != null) {
                rowData = (String)this.jdbcTemplate.queryForObject(this.dbDialect.createCsvDataSql(trigger, whereClause), String.class);
                pkData = (String)this.jdbcTemplate.queryForObject(this.dbDialect.createCsvPrimaryKeySql(trigger, whereClause), String.class);
            }
            if ((history = this.triggerRouterService.getNewestTriggerHistoryForTrigger(trigger.getTriggerId())) == null && (history = this.triggerRouterService.findTriggerHistory(trigger.getSourceTableName())) == null) {
                history = this.triggerRouterService.findTriggerHistory(trigger.getSourceTableName().toUpperCase());
            }
            if (history != null) {
                data = new Data(trigger.getSourceTableName(), DataEventType.UPDATE, rowData, pkData, history, isReload ? "reload" : trigger.getChannelId(), null, null);
            }
        }
        return data;
    }

    @Override
    public DataRef getDataRef() {
        List refs = this.getSimpleTemplate().query(this.getSql("findDataRefSql"), (RowMapper)new RowMapper<DataRef>(){

            public DataRef mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new DataRef(rs.getLong(1), rs.getDate(2));
            }
        }, new Object[0]);
        if (refs.size() > 0) {
            return (DataRef)refs.get(0);
        }
        return new DataRef(-1L, new Date());
    }

    @Override
    public void saveDataRef(DataRef dataRef) {
        if (0 >= this.jdbcTemplate.update(this.getSql("updateDataRefSql"), new Object[]{dataRef.getRefDataId(), dataRef.getRefTime()}, new int[]{2, 93})) {
            this.jdbcTemplate.update(this.getSql("insertDataRefSql"), new Object[]{dataRef.getRefDataId(), dataRef.getRefTime()}, new int[]{2, 93});
        }
    }

    @Override
    public Date findCreateTimeOfEvent(long dataId) {
        return (Date)this.jdbcTemplate.queryForObject(this.getSql("findDataEventCreateTimeSql"), new Object[]{dataId}, new int[]{2}, Date.class);
    }

    @Override
    public Date findCreateTimeOfData(long dataId) {
        return (Date)this.jdbcTemplate.queryForObject(this.getSql("findDataCreateTimeSql"), new Object[]{dataId}, new int[]{2}, Date.class);
    }

    @Override
    public Map<String, String> getRowDataAsMap(Data data) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] columnNames = CsvUtils.tokenizeCsvData(data.getTriggerHistory().getColumnNames());
        String[] columnData = CsvUtils.tokenizeCsvData(data.getRowData());
        for (int i = 0; i < columnNames.length; ++i) {
            map.put(columnNames[i].toLowerCase(), columnData[i]);
        }
        return map;
    }

    @Override
    public void setRowDataFromMap(Data data, Map<String, String> map) {
        String[] columnNames = CsvUtils.tokenizeCsvData(data.getTriggerHistory().getColumnNames());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CsvWriter writer = new CsvWriter(new OutputStreamWriter(out), ',');
        writer.setEscapeMode(2);
        for (String columnName : columnNames) {
            try {
                writer.write(map.get(columnName.toLowerCase()), true);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        writer.close();
        data.setRowData(out.toString());
    }

    protected List<IHeartbeatListener> getHeartbeatListeners(boolean force) {
        if (force) {
            return this.heartbeatListeners;
        }
        ArrayList<IHeartbeatListener> listeners = new ArrayList<IHeartbeatListener>();
        if (listeners != null) {
            long ts = System.currentTimeMillis();
            for (IHeartbeatListener iHeartbeatListener : this.heartbeatListeners) {
                Long lastHeartbeatTimestamp = this.lastHeartbeatTimestamps.get(iHeartbeatListener);
                if (lastHeartbeatTimestamp != null && lastHeartbeatTimestamp > ts - iHeartbeatListener.getTimeBetweenHeartbeatsInSeconds() * 1000L) continue;
                listeners.add(iHeartbeatListener);
            }
        }
        return listeners;
    }

    protected void updateLastHeartbeatTime(List<IHeartbeatListener> listeners) {
        if (listeners != null) {
            Long ts = System.currentTimeMillis();
            for (IHeartbeatListener iHeartbeatListener : listeners) {
                this.lastHeartbeatTimestamps.put(iHeartbeatListener, ts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartbeat(boolean force) {
        List<IHeartbeatListener> listeners = this.getHeartbeatListeners(force);
        if (listeners.size() > 0) {
            if (this.clusterService.lock("HEARTBEAT")) {
                try {
                    Node me = this.nodeService.findIdentity();
                    if (me != null) {
                        this.log.info("NodeVersionUpdating");
                        Calendar now = Calendar.getInstance();
                        now.set(14, 0);
                        me.setHeartbeatTime(now.getTime());
                        me.setTimezoneOffset(AppUtils.getTimezoneOffset());
                        me.setSymmetricVersion(Version.version());
                        me.setDatabaseType(this.dbDialect.getName());
                        me.setDatabaseVersion(this.dbDialect.getVersion());
                        me.setBatchToSendCount(this.outgoingBatchService.countOutgoingBatchesWithStatus(OutgoingBatch.Status.NE));
                        me.setBatchInErrorCount(this.outgoingBatchService.countOutgoingBatchesWithStatus(OutgoingBatch.Status.ER));
                        if (this.parameterService.is("auto.update.node.values.from.properties")) {
                            this.log.info("NodeConfigurationUpdating");
                            me.setSchemaVersion(this.parameterService.getString("schema.version"));
                            me.setExternalId(this.parameterService.getExternalId());
                            me.setNodeGroupId(this.parameterService.getNodeGroupId());
                            if (!StringUtils.isBlank((String)this.parameterService.getSyncUrl())) {
                                me.setSyncUrl(this.parameterService.getSyncUrl());
                            }
                        }
                        this.nodeService.updateNode(me);
                        this.nodeService.updateNodeHostForCurrentNode();
                        this.log.info("NodeVersionUpdated");
                        Set<Node> children = this.nodeService.findNodesThatOriginatedFromNodeId(me.getNodeId());
                        for (IHeartbeatListener l : listeners) {
                            l.heartbeat(me, children);
                        }
                    }
                    Object var9_8 = null;
                    this.updateLastHeartbeatTime(listeners);
                    this.clusterService.unlock("HEARTBEAT");
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    this.updateLastHeartbeatTime(listeners);
                    this.clusterService.unlock("HEARTBEAT");
                    throw throwable;
                }
            } else {
                this.log.info("HeartbeatUpdatingFailure");
            }
        }
    }

    @Override
    public void setReloadListeners(List<IReloadListener> listeners) {
        this.reloadListeners = listeners;
    }

    @Override
    public void addReloadListener(IReloadListener listener) {
        if (this.reloadListeners == null) {
            this.reloadListeners = new ArrayList<IReloadListener>();
        }
        this.reloadListeners.add(listener);
    }

    @Override
    public boolean removeReloadListener(IReloadListener listener) {
        if (this.reloadListeners != null) {
            return this.reloadListeners.remove(listener);
        }
        return false;
    }

    public void setHeartbeatListeners(List<IHeartbeatListener> listeners) {
        this.heartbeatListeners = listeners;
    }

    @Override
    public void addHeartbeatListener(IHeartbeatListener listener) {
        if (this.heartbeatListeners == null) {
            this.heartbeatListeners = new ArrayList<IHeartbeatListener>();
        }
        this.heartbeatListeners.add(listener);
    }

    public boolean removeHeartbeatListener(IHeartbeatListener listener) {
        if (this.heartbeatListeners != null) {
            return this.heartbeatListeners.remove(listener);
        }
        return false;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerService) {
        this.triggerRouterService = triggerService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPurgeService(IPurgeService purgeService) {
        this.purgeService = purgeService;
    }

    public void setOutgoingBatchService(IOutgoingBatchService outgoingBatchService) {
        this.outgoingBatchService = outgoingBatchService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public Data readData(ResultSet results) throws SQLException {
        Data data = new Data();
        data.setDataId(results.getLong(1));
        data.setTableName(results.getString(2));
        data.setEventType(DataEventType.getEventType(results.getString(3)));
        data.setRowData(results.getString(4));
        data.setPkData(results.getString(5));
        data.setOldData(results.getString(6));
        data.setCreateTime(results.getDate(7));
        int histId = results.getInt(8);
        data.setTriggerHistory(this.triggerRouterService.getTriggerHistory(histId));
        data.setChannelId(results.getString(9));
        data.setTransactionId(results.getString(10));
        data.setSourceNodeId(results.getString(11));
        data.setExternalData(results.getString(12));
        return data;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransactionalInsertReloadEventsDelegate
    implements TransactionCallback<Object> {
        Node targetNode;

        public TransactionalInsertReloadEventsDelegate(Node targetNode) {
            this.targetNode = targetNode;
        }

        public Object doInTransaction(TransactionStatus status) {
            Node sourceNode = DataService.this.nodeService.findIdentity();
            if (DataService.this.reloadListeners != null) {
                for (IReloadListener listener : DataService.this.reloadListeners) {
                    listener.beforeReload(this.targetNode);
                }
            }
            DataService.this.insertNodeSecurityUpdate(this.targetNode, true);
            List<TriggerRouter> triggerRouters = DataService.this.triggerRouterService.getAllTriggerRoutersForReloadForCurrentNode(sourceNode.getNodeGroupId(), this.targetNode.getNodeGroupId());
            if (DataService.this.parameterService.is("initial.load.create.first")) {
                for (TriggerRouter triggerRouter : triggerRouters) {
                    String xml = DataService.this.dbDialect.getCreateTableXML(triggerRouter);
                    DataService.this.insertCreateEvent(this.targetNode, triggerRouter, xml);
                }
            }
            if (DataService.this.parameterService.is("initial.load.delete.first")) {
                ListIterator<TriggerRouter> iterator = triggerRouters.listIterator(triggerRouters.size());
                while (iterator.hasPrevious()) {
                    TriggerRouter triggerRouter;
                    triggerRouter = iterator.previous();
                    DataService.this.insertPurgeEvent(this.targetNode, triggerRouter);
                }
            }
            for (TriggerRouter trigger : triggerRouters) {
                DataService.this.insertReloadEvent(this.targetNode, trigger);
            }
            if (DataService.this.reloadListeners != null) {
                for (IReloadListener listener : DataService.this.reloadListeners) {
                    listener.afterReload(this.targetNode);
                }
            }
            DataService.this.nodeService.setInitialLoadEnabled(this.targetNode.getNodeId(), false);
            DataService.this.insertNodeSecurityUpdate(this.targetNode, true);
            return null;
        }
    }
}

