/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.io.ThresholdFileWriter;
import org.jumpmind.symmetric.load.IBatchListener;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.IDataLoader;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.load.IDataLoaderStatistics;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.RegistrationNotOpenException;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.TransportException;
import org.jumpmind.symmetric.transport.file.FileIncomingTransport;
import org.jumpmind.symmetric.transport.internal.InternalIncomingTransport;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataLoaderService
extends AbstractService
implements IDataLoaderService,
BeanFactoryAware {
    private IDbDialect dbDialect;
    private IIncomingBatchService incomingBatchService;
    private IConfigurationService configurationService;
    private ITransportManager transportManager;
    private BeanFactory beanFactory;
    private List<IDataLoaderFilter> filters;
    private IStatisticManager statisticManager;
    private INodeService nodeService;
    private Map<String, List<IColumnFilter>> columnFilters = new HashMap<String, List<IColumnFilter>>();
    private List<IBatchListener> batchListeners;

    @Override
    public boolean loadData(Node remote, Node local) throws IOException {
        boolean wasWorkDone = false;
        try {
            NodeSecurity localSecurity = this.nodeService.findNodeSecurity(local.getNodeId());
            HashMap<String, String> requestProperties = new HashMap<String, String>();
            ChannelMap suspendIgnoreChannels = this.configurationService.getSuspendIgnoreChannelLists();
            requestProperties.put("Suspended-Channels", suspendIgnoreChannels.getSuspendChannelsAsString());
            requestProperties.put("Ignored-Channels", suspendIgnoreChannels.getIgnoreChannelsAsString());
            List<IncomingBatch> list = this.loadDataAndReturnBatches(this.transportManager.getPullTransport(remote, local, localSecurity.getNodePassword(), requestProperties, this.parameterService.getRegistrationUrl()));
            if (list.size() > 0) {
                this.sendAck(remote, local, localSecurity, list);
                wasWorkDone = true;
            }
        }
        catch (RegistrationRequiredException e) {
            this.log.warn("RegistrationLost");
            this.loadData(this.transportManager.getRegisterTransport(local, this.parameterService.getRegistrationUrl()));
            this.nodeService.findIdentity(false);
            wasWorkDone = true;
        }
        catch (MalformedURLException e) {
            this.log.error("URLConnectingFailure", remote.getNodeId(), remote.getSyncUrl());
        }
        return wasWorkDone;
    }

    private void sendAck(Node remote, Node local, NodeSecurity localSecurity, List<IncomingBatch> list) throws IOException {
        Exception error = null;
        int sendAck = -1;
        int numberOfStatusSendRetries = this.parameterService.getInt("num.of.ack.retries");
        for (int i = 0; i < numberOfStatusSendRetries && sendAck != 200; ++i) {
            try {
                sendAck = this.transportManager.sendAcknowledgement(remote, list, local, localSecurity.getNodePassword(), this.parameterService.getRegistrationUrl());
            }
            catch (IOException ex) {
                this.log.warn("AckSendingFailed", i + 1, ex.getMessage());
                error = ex;
            }
            catch (RuntimeException ex) {
                this.log.warn("AckSendingFailed", i + 1, ex.getMessage());
                error = ex;
            }
            if (sendAck == 200) continue;
            if (i < numberOfStatusSendRetries - 1) {
                AppUtils.sleep(this.parameterService.getLong("time.between.ack.retries.ms"));
                continue;
            }
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof IOException) {
                throw error;
            }
            throw new IOException(Integer.toString(sendAck));
        }
    }

    @Override
    public IDataLoader openDataLoader(BufferedReader reader) throws IOException {
        IDataLoader dataLoader = (IDataLoader)this.beanFactory.getBean("dataLoader");
        dataLoader.open(reader, this.filters, this.columnFilters);
        return dataLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataLoaderStatistics loadDataBatch(String batchData) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(batchData));
        IDataLoader dataLoader = this.openDataLoader(reader);
        IDataLoaderStatistics stats = null;
        try {
            while (dataLoader.hasNext()) {
                dataLoader.load();
                IncomingBatch history = new IncomingBatch(dataLoader.getContext());
                history.setValues(dataLoader.getStatistics(), true);
                this.fireBatchComplete(dataLoader, history);
            }
            Object var7_6 = null;
            stats = dataLoader.getStatistics();
            dataLoader.close();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            stats = dataLoader.getStatistics();
            dataLoader.close();
            throw throwable;
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IncomingBatch> loadDataAndReturnBatches(IIncomingTransport transport) throws IOException {
        ArrayList<IncomingBatch> list;
        block30: {
            list = new ArrayList<IncomingBatch>();
            IncomingBatch batch = null;
            IDataLoader dataLoader = null;
            try {
                try {
                    long totalNetworkMillis = System.currentTimeMillis();
                    if (this.parameterService.is("stream.to.file.enabled")) {
                        transport = this.writeToFile(transport);
                        totalNetworkMillis = System.currentTimeMillis() - totalNetworkMillis;
                    }
                    dataLoader = this.openDataLoader(transport.open());
                    IDataLoaderContext context = dataLoader.getContext();
                    while (dataLoader.hasNext()) {
                        batch = new IncomingBatch(context);
                        if (this.parameterService.is("dataloader.enable") || batch.getChannelId() != null && batch.getChannelId().equals("config")) {
                            list.add(batch);
                            this.loadBatch(dataLoader, batch);
                        }
                        batch = null;
                    }
                    if (this.parameterService.is("stream.to.file.enabled")) {
                        this.estimateNetworkMillis(list, totalNetworkMillis);
                    }
                    for (IncomingBatch incomingBatch : list) {
                        if (!incomingBatch.isPersistable()) continue;
                        this.incomingBatchService.updateIncomingBatch(incomingBatch);
                    }
                    Object var11_17 = null;
                    if (dataLoader == null) break block30;
                }
                catch (RegistrationRequiredException ex) {
                    throw ex;
                }
                catch (ConnectException ex) {
                    this.statisticManager.getStatistic("INCOMING_TRANSPORT_CONNECT_ERROR_COUNT").increment();
                    throw ex;
                }
                catch (UnknownHostException ex) {
                    this.log.warn("TransportFailedUnknownHost", ex.getMessage());
                    this.statisticManager.getStatistic("INCOMING_TRANSPORT_CONNECT_ERROR_COUNT").increment();
                    throw ex;
                }
                catch (RegistrationNotOpenException ex) {
                    this.log.warn("RegistrationFailed");
                    Object var11_18 = null;
                    if (dataLoader != null) {
                        dataLoader.close();
                    }
                    transport.close();
                    this.recordStatistics(list);
                    return list;
                }
                catch (ConnectionRejectedException ex) {
                    this.log.warn("TransportFailedConnectionBusy");
                    this.statisticManager.getStatistic("INCOMING_TRANSPORT_REJECTED_COUNT").increment();
                    throw ex;
                }
                catch (AuthenticationException ex) {
                    this.log.warn("AuthenticationFailed");
                    Object var11_19 = null;
                    if (dataLoader != null) {
                        dataLoader.close();
                    }
                    transport.close();
                    this.recordStatistics(list);
                    return list;
                }
                catch (SyncDisabledException ex) {
                    this.log.warn("SyncDisabled");
                    throw ex;
                }
                catch (Throwable e) {
                    if (dataLoader != null && dataLoader.getContext().getBatchId() > 0L && batch == null) {
                        batch = new IncomingBatch(dataLoader.getContext());
                        list.add(batch);
                    }
                    if (dataLoader != null && batch != null) {
                        if (e instanceof IOException || e instanceof TransportException) {
                            this.log.warn("BatchLoadingFailed", batch.getNodeBatchId(), e.getMessage());
                            batch.setSqlMessage(e.getMessage());
                            this.statisticManager.getStatistic("INCOMING_TRANSPORT_ERROR_COUNT").increment();
                        } else {
                            this.log.error("BatchLoadingFailed", e, batch.getNodeBatchId(), e.getMessage());
                            SQLException se = this.unwrapSqlException(e);
                            if (se != null) {
                                this.statisticManager.getStatistic("INCOMING_DATABASE_ERROR_COUNT").increment();
                                batch.setSqlState(se.getSQLState());
                                batch.setSqlCode(se.getErrorCode());
                                batch.setSqlMessage(se.getMessage());
                            } else {
                                batch.setSqlMessage(e.getMessage());
                                this.statisticManager.getStatistic("INCOMING_OTHER_ERROR_COUNT").increment();
                            }
                        }
                        batch.setValues(dataLoader.getStatistics(), false);
                        this.handleBatchError(batch);
                    } else if (e instanceof IOException) {
                        this.log.error("BatchReadingFailed", e.getMessage());
                    } else {
                        this.log.error("BatchParsingFailed", e);
                    }
                    Object var11_20 = null;
                    if (dataLoader != null) {
                        dataLoader.close();
                    }
                    transport.close();
                    this.recordStatistics(list);
                    return list;
                }
                dataLoader.close();
            }
            catch (Throwable throwable) {
                Object var11_21 = null;
                if (dataLoader != null) {
                    dataLoader.close();
                }
                transport.close();
                this.recordStatistics(list);
                throw throwable;
            }
        }
        transport.close();
        this.recordStatistics(list);
        return list;
    }

    protected void estimateNetworkMillis(List<IncomingBatch> list, long totalNetworkMillis) {
        long totalNumberOfBytes = 0L;
        for (IncomingBatch incomingBatch : list) {
            totalNumberOfBytes += incomingBatch.getByteCount();
        }
        for (IncomingBatch incomingBatch : list) {
            if (totalNumberOfBytes <= 0L) continue;
            double ratio = (double)incomingBatch.getByteCount() / (double)totalNumberOfBytes;
            incomingBatch.setNetworkMillis((long)((double)totalNetworkMillis * ratio));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IIncomingTransport writeToFile(IIncomingTransport transport) throws IOException {
        ThresholdFileWriter writer = null;
        try {
            writer = new ThresholdFileWriter(this.parameterService.getLong("stream.to.file.threshold.bytes"), "load");
            IOUtils.copy((Reader)transport.open(), (Writer)writer);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtils.closeQuietly(writer);
            transport.close();
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        transport.close();
        return new FileIncomingTransport(writer);
    }

    private void recordStatistics(List<IncomingBatch> list) {
        if (list != null) {
            this.statisticManager.getStatistic("INCOMING_BATCH_COUNT").add(list.size());
            for (IncomingBatch incomingBatch : list) {
                this.statisticManager.getStatistic("INCOMING_MS_PER_ROW").add(incomingBatch.getDatabaseMillis(), incomingBatch.getStatementCount());
                this.statisticManager.getStatistic("INCOMING_BATCH_COUNT").increment();
                if (!IncomingBatch.Status.SK.equals((Object)incomingBatch.getStatus())) continue;
                this.statisticManager.getStatistic("INCOMING_SKIP_BATCH_COUNT").increment();
            }
        }
    }

    @Override
    public boolean loadData(IIncomingTransport transport) throws IOException {
        boolean inError = false;
        List<IncomingBatch> list = this.loadDataAndReturnBatches(transport);
        if (list != null && list.size() > 0) {
            for (IncomingBatch incomingBatch : list) {
                inError |= incomingBatch.getStatus() != IncomingBatch.Status.OK;
            }
        } else {
            inError = true;
        }
        return !inError;
    }

    private void fireEarlyCommit(IDataLoader loader, IncomingBatch batch) {
        if (this.batchListeners != null) {
            long ts = System.currentTimeMillis();
            for (IBatchListener listener : this.batchListeners) {
                listener.earlyCommit(loader, batch);
            }
            batch.setFilterMillis(batch.getFilterMillis() + (System.currentTimeMillis() - ts));
        }
    }

    private void fireBatchComplete(IDataLoader loader, IncomingBatch batch) {
        if (this.batchListeners != null) {
            long ts = System.currentTimeMillis();
            for (IBatchListener listener : this.batchListeners) {
                listener.batchComplete(loader, batch);
            }
            batch.setFilterMillis(batch.getFilterMillis() + (System.currentTimeMillis() - ts));
        }
    }

    private void fireBatchCommitted(IDataLoader loader, IncomingBatch batch) {
        if (this.batchListeners != null) {
            long ts = System.currentTimeMillis();
            for (IBatchListener listener : this.batchListeners) {
                listener.batchCommitted(loader, batch);
            }
            batch.setFilterMillis(batch.getFilterMillis() + (System.currentTimeMillis() - ts));
        }
    }

    private void fireBatchRolledback(IDataLoader loader, IncomingBatch batch, Exception ex) {
        if (this.batchListeners != null) {
            long ts = System.currentTimeMillis();
            for (IBatchListener listener : this.batchListeners) {
                listener.batchRolledback(loader, batch, ex);
            }
            batch.setFilterMillis(batch.getFilterMillis() + (System.currentTimeMillis() - ts));
        }
    }

    protected void handleBatchError(IncomingBatch status) {
        try {
            if (!status.isRetry()) {
                status.setStatus(IncomingBatch.Status.ER);
                this.incomingBatchService.insertIncomingBatch(status);
            }
        }
        catch (Exception e) {
            this.log.error("BatchStatusRecordFailed", status.getNodeBatchId());
        }
    }

    @Override
    public void loadData(InputStream in, OutputStream out) throws IOException {
        Node local;
        List<IncomingBatch> list = this.loadDataAndReturnBatches(new InternalIncomingTransport(in));
        NodeSecurity security = this.nodeService.findNodeSecurity((local = this.nodeService.findIdentity()).getNodeId());
        this.transportManager.writeAcknowledgement(out, list, local, security != null ? security.getNodePassword() : null);
    }

    @Override
    public void setDataLoaderFilters(List<IDataLoaderFilter> filters) {
        this.filters = filters;
    }

    @Override
    public void addDataLoaderFilter(IDataLoaderFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<IDataLoaderFilter>();
        }
        this.filters.add(filter);
    }

    @Override
    public void removeDataLoaderFilter(IDataLoaderFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public void setTransportManager(ITransportManager remoteService) {
        this.transportManager = remoteService;
    }

    public void setIncomingBatchService(IIncomingBatchService incomingBatchService) {
        this.incomingBatchService = incomingBatchService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    @Override
    public void addColumnFilter(String tableName, IColumnFilter filter) {
        List<IColumnFilter> filters = this.columnFilters.get(tableName);
        if (filters == null) {
            filters = new ArrayList<IColumnFilter>();
            this.columnFilters.put(tableName, filters);
        }
        filters.add(filter);
    }

    @Override
    public void reRegisterColumnFilter(String[] tableNames, IColumnFilter filter) {
        Set<Map.Entry<String, List<IColumnFilter>>> entries = this.columnFilters.entrySet();
        for (Map.Entry<String, List<IColumnFilter>> entry : entries) {
            if (!entry.getValue().contains(filter)) continue;
            entry.getValue().remove(filter);
        }
        if (tableNames != null) {
            for (String name : tableNames) {
                this.addColumnFilter(name, filter);
            }
        }
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    @Override
    public void addBatchListener(IBatchListener batchListener) {
        if (this.batchListeners == null) {
            this.batchListeners = new ArrayList<IBatchListener>();
        }
        this.batchListeners.add(batchListener);
    }

    public void setBatchListeners(List<IBatchListener> batchListeners) {
        this.batchListeners = batchListeners;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void loadBatch(IDataLoader dataLoader, IncomingBatch batch) {
        try {
            TransactionalLoadDelegate loadDelegate = new TransactionalLoadDelegate(batch, dataLoader);
            LoadStatus loadStatus = loadDelegate.getLoadStatus();
            do {
                this.newTransactionTemplate.execute((TransactionCallback)loadDelegate);
                loadStatus = loadDelegate.getLoadStatus();
                if (loadStatus != LoadStatus.CONTINUE) continue;
                this.statisticManager.getStatistic("INCOMING_MAX_ROWS_COMMITED").increment();
                AppUtils.sleep(5L);
            } while (LoadStatus.CONTINUE == loadStatus);
            this.fireBatchCommitted(dataLoader, batch);
        }
        catch (RuntimeException ex) {
            this.fireBatchRolledback(dataLoader, batch, ex);
            throw ex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransactionalLoadDelegate
    implements TransactionCallback<LoadStatus> {
        IncomingBatch batch;
        IDataLoader dataLoader;
        LoadStatus loadStatus = LoadStatus.DONE;

        public TransactionalLoadDelegate(IncomingBatch status, IDataLoader dataLoader) {
            this.batch = status;
            this.dataLoader = dataLoader;
        }

        public LoadStatus doInTransaction(TransactionStatus txStatus) {
            try {
                boolean done = true;
                DataLoaderService.this.dbDialect.disableSyncTriggers(this.dataLoader.getContext().getNodeId());
                if (this.loadStatus == LoadStatus.CONTINUE || DataLoaderService.this.incomingBatchService.acquireIncomingBatch(this.batch)) {
                    done = this.dataLoader.load();
                } else {
                    this.dataLoader.skip();
                }
                this.batch.setValues(this.dataLoader.getStatistics(), true);
                if (done) {
                    DataLoaderService.this.fireBatchComplete(this.dataLoader, this.batch);
                    this.loadStatus = LoadStatus.DONE;
                } else {
                    DataLoaderService.this.log.info("LoaderEarlyCommit", this.batch.getBatchId(), this.dataLoader.getContext().getTableName(), this.dataLoader.getStatistics().getLineCount());
                    DataLoaderService.this.fireEarlyCommit(this.dataLoader, this.batch);
                    this.loadStatus = LoadStatus.CONTINUE;
                }
                LoadStatus loadStatus = this.loadStatus;
                Object var5_5 = null;
                DataLoaderService.this.dbDialect.enableSyncTriggers();
                return loadStatus;
            }
            catch (IOException e) {
                try {
                    throw new TransportException(e);
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    DataLoaderService.this.dbDialect.enableSyncTriggers();
                    throw throwable;
                }
            }
        }

        public LoadStatus getLoadStatus() {
            return this.loadStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoadStatus {
        CONTINUE,
        DONE;

    }
}

