/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.jumpmind.symmetric.db.SqlScript;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroupChannelWindow;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationService
extends AbstractService
implements IConfigurationService {
    private INodeService nodeService;
    private Map<String, List<NodeChannel>> nodeChannelCache;
    private long nodeChannelCacheTime;
    private List<Channel> defaultChannels;

    @Override
    public List<NodeGroupLink> getGroupLinks() {
        return this.jdbcTemplate.query(this.getSql("groupsLinksSql"), (RowMapper)new NodeGroupLinkMapper());
    }

    @Override
    public List<NodeGroupLink> getGroupLinksFor(String sourceNodeGroupId) {
        return this.jdbcTemplate.query(this.getSql("groupsLinksForSql"), new Object[]{sourceNodeGroupId}, (RowMapper)new NodeGroupLinkMapper());
    }

    @Override
    public List<NodeGroupLink> getGroupLinksFor(String sourceNodeGroupId, String targetNodeGroupId) {
        List<NodeGroupLink> links = this.getGroupLinksFor(sourceNodeGroupId);
        Iterator<NodeGroupLink> it = links.iterator();
        while (it.hasNext()) {
            NodeGroupLink nodeGroupLink = it.next();
            if (nodeGroupLink.getTargetNodeGroupId().equals(targetNodeGroupId)) continue;
            it.remove();
        }
        return links;
    }

    @Override
    public void saveChannel(Channel channel, boolean reloadChannels) {
        if (0 == this.jdbcTemplate.update(this.getSql("updateChannelSql"), new Object[]{channel.getProcessingOrder(), channel.getMaxBatchSize(), channel.getMaxBatchToSend(), channel.getMaxDataToRoute(), channel.isUseOldDataToRoute() ? 1 : 0, channel.isUseRowDataToRoute() ? 1 : 0, channel.isUsePkDataToRoute() ? 1 : 0, channel.isEnabled() ? 1 : 0, channel.getBatchAlgorithm(), channel.getExtractPeriodMillis(), channel.getChannelId()})) {
            this.jdbcTemplate.update(this.getSql("insertChannelSql"), new Object[]{channel.getChannelId(), channel.getProcessingOrder(), channel.getMaxBatchSize(), channel.getMaxBatchToSend(), channel.getMaxDataToRoute(), channel.isUseOldDataToRoute() ? 1 : 0, channel.isUseRowDataToRoute() ? 1 : 0, channel.isUsePkDataToRoute() ? 1 : 0, channel.isEnabled() ? 1 : 0, channel.getBatchAlgorithm(), channel.getExtractPeriodMillis()});
        }
        if (reloadChannels) {
            this.reloadChannels();
        }
    }

    @Override
    public void saveChannel(NodeChannel nodeChannel, boolean reloadChannels) {
        this.saveChannel(nodeChannel.getChannel(), reloadChannels);
    }

    @Override
    public void saveNodeChannel(NodeChannel nodeChannel, boolean reloadChannels) {
        this.saveChannel(nodeChannel.getChannel(), false);
        this.saveNodeChannelControl(nodeChannel, reloadChannels);
    }

    @Override
    public void saveNodeChannelControl(NodeChannel nodeChannel, boolean reloadChannels) {
        if (0 == this.jdbcTemplate.update(this.getSql("updateNodeChannelControlSql"), new Object[]{nodeChannel.isSuspendEnabled() ? 1 : 0, nodeChannel.isIgnoreEnabled() ? 1 : 0, nodeChannel.getLastExtractedTime(), nodeChannel.getNodeId(), nodeChannel.getChannelId()})) {
            this.jdbcTemplate.update(this.getSql("insertNodeChannelControlSql"), new Object[]{nodeChannel.getNodeId(), nodeChannel.getChannelId(), nodeChannel.isSuspendEnabled() ? 1 : 0, nodeChannel.isIgnoreEnabled() ? 1 : 0, nodeChannel.getLastExtractedTime()});
        }
        if (reloadChannels) {
            this.reloadChannels();
        }
    }

    @Override
    public void deleteChannel(Channel channel) {
        this.jdbcTemplate.update(this.getSql("deleteChannelSql"), new Object[]{channel.getChannelId()});
    }

    @Override
    public NodeChannel getNodeChannel(String channelId) {
        return this.getNodeChannel(channelId, this.nodeService.findIdentityNodeId());
    }

    @Override
    public NodeChannel getNodeChannel(String channelId, String nodeId) {
        List<NodeChannel> channels = this.getNodeChannels(nodeId);
        for (NodeChannel nodeChannel : channels) {
            if (!nodeChannel.getChannelId().equals(channelId)) continue;
            return nodeChannel;
        }
        return null;
    }

    @Override
    public List<NodeChannel> getNodeChannels() {
        return this.getNodeChannels(this.nodeService.findIdentityNodeId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeChannel> getNodeChannels(final String nodeId) {
        List nodeChannels;
        boolean loaded = false;
        long channelCacheTimeoutInMs = this.parameterService.getLong("cache.channel.time.ms");
        List list = nodeChannels = this.nodeChannelCache != null ? this.nodeChannelCache.get(nodeId) : null;
        if (System.currentTimeMillis() - this.nodeChannelCacheTime >= channelCacheTimeoutInMs || nodeChannels == null) {
            ConfigurationService configurationService = this;
            synchronized (configurationService) {
                if (System.currentTimeMillis() - this.nodeChannelCacheTime >= channelCacheTimeoutInMs || this.nodeChannelCache == null || this.nodeChannelCache.get(nodeId) == null || nodeChannels == null) {
                    if (System.currentTimeMillis() - this.nodeChannelCacheTime >= channelCacheTimeoutInMs || this.nodeChannelCache == null) {
                        this.nodeChannelCache = new HashMap<String, List<NodeChannel>>();
                        this.nodeChannelCacheTime = System.currentTimeMillis();
                    }
                    nodeChannels = this.jdbcTemplate.query(this.getSql("selectChannelsSql"), new Object[]{nodeId}, new RowMapper(){

                        public Object mapRow(ResultSet rs, int arg1) throws SQLException {
                            NodeChannel nodeChannel = new NodeChannel();
                            nodeChannel.setChannelId(rs.getString(1));
                            nodeChannel.setNodeId(nodeId);
                            nodeChannel.setIgnoreEnabled(ConfigurationService.this.isSet(rs.getObject(3)));
                            nodeChannel.setSuspendEnabled(ConfigurationService.this.isSet(rs.getObject(4)));
                            nodeChannel.setProcessingOrder(rs.getInt(5));
                            nodeChannel.setMaxBatchSize(rs.getInt(6));
                            nodeChannel.setEnabled(rs.getBoolean(7));
                            nodeChannel.setMaxBatchToSend(rs.getInt(8));
                            nodeChannel.setMaxDataToRoute(rs.getInt(9));
                            nodeChannel.setUseOldDataToRoute(rs.getBoolean(10));
                            nodeChannel.setUseRowDataToRoute(rs.getBoolean(11));
                            nodeChannel.setUsePkDataToRoute(rs.getBoolean(12));
                            nodeChannel.setBatchAlgorithm(rs.getString(13));
                            nodeChannel.setLastExtractedTime(rs.getTimestamp(14));
                            nodeChannel.setExtractPeriodMillis(rs.getLong(15));
                            return nodeChannel;
                        }
                    });
                    this.nodeChannelCache.put(nodeId, nodeChannels);
                    loaded = true;
                }
            }
        }
        if (!loaded) {
            final HashMap<String, NodeChannel> nodeChannelsMap = new HashMap<String, NodeChannel>();
            for (NodeChannel nc : nodeChannels) {
                nodeChannelsMap.put(nc.getChannelId(), nc);
            }
            this.jdbcTemplate.query(this.getSql("selectNodeChannelControlLastExtractTimeSql"), new Object[]{nodeId}, new ResultSetExtractor(){

                public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                    if (rs.next()) {
                        String channelId = rs.getString(1);
                        Timestamp extractTime = rs.getTimestamp(2);
                        ((NodeChannel)nodeChannelsMap.get(channelId)).setLastExtractedTime(extractTime);
                    }
                    return null;
                }
            });
        }
        return nodeChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadChannels() {
        ConfigurationService configurationService = this;
        synchronized (configurationService) {
            this.nodeChannelCache = null;
        }
    }

    private boolean isSet(Object value) {
        return value != null && value.toString().equals("1");
    }

    @Override
    public NodeGroupLinkAction getDataEventActionsByGroupId(String sourceGroupId, String targetGroupId) {
        String code = (String)this.jdbcTemplate.queryForObject(this.getSql("selectDataEventActionsByIdSql"), new Object[]{sourceGroupId, targetGroupId}, String.class);
        return NodeGroupLinkAction.fromCode(code);
    }

    @Override
    public void autoConfigDatabase(boolean force) {
        if (this.parameterService.is("auto.config.database") || force) {
            this.log.info("SymmetricDSDatabaseInitializing");
            this.dbDialect.initTablesAndFunctions();
            this.autoConfigChannels();
            this.autoConfigRegistrationServer();
            this.parameterService.rereadParameters();
            this.log.info("SymmetricDSDatabaseInitialized");
        } else {
            this.log.info("SymmetricDSDatabaseNotAutoConfig");
        }
    }

    protected void autoConfigChannels() {
        if (this.defaultChannels != null) {
            this.reloadChannels();
            List<NodeChannel> channels = this.getNodeChannels();
            for (Channel defaultChannel : this.defaultChannels) {
                if (!defaultChannel.isInList(channels)) {
                    this.log.info("ChannelAutoConfiguring", defaultChannel.getChannelId());
                    this.saveChannel(defaultChannel, true);
                    continue;
                }
                this.log.info("ChannelExists", defaultChannel.getChannelId());
            }
            this.reloadChannels();
        }
    }

    protected void autoConfigRegistrationServer() {
        Node node = this.nodeService.findIdentity();
        if (node == null) {
            this.buildTablesFromDdlUtilXmlIfProvided();
            this.loadFromScriptIfProvided();
        }
        if (node == null && StringUtils.isBlank((String)this.parameterService.getRegistrationUrl()) && this.parameterService.is("auto.insert.registration.svr.if.not.found")) {
            this.log.info("AutoConfigRegistrationService");
            String nodeGroupId = this.parameterService.getNodeGroupId();
            String nodeId = this.parameterService.getExternalId();
            this.nodeService.insertNode(nodeId, nodeGroupId, nodeId, nodeId);
            this.nodeService.insertNodeIdentity(nodeId);
            node = this.nodeService.findIdentity();
            node.setSyncUrl(this.parameterService.getSyncUrl());
            node.setSyncEnabled(true);
            node.setHeartbeatTime(new Date());
            this.nodeService.updateNode(node);
            NodeSecurity nodeSecurity = this.nodeService.findNodeSecurity(nodeId, true);
            nodeSecurity.setInitialLoadTime(new Date());
            nodeSecurity.setRegistrationTime(new Date());
            nodeSecurity.setInitialLoadEnabled(false);
            nodeSecurity.setRegistrationEnabled(false);
            this.nodeService.updateNodeSecurity(nodeSecurity);
        }
    }

    private boolean buildTablesFromDdlUtilXmlIfProvided() {
        boolean loaded = false;
        String xml = this.parameterService.getString("auto.config.registration.svr.ddlutil.xml");
        if (!StringUtils.isBlank((String)xml)) {
            File file = new File(xml);
            URL fileUrl = null;
            if (file.isFile()) {
                try {
                    fileUrl = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            } else {
                fileUrl = this.getClass().getResource(xml);
            }
            if (fileUrl != null) {
                try {
                    this.log.info("DatabaseSchemaBuilding", xml);
                    Database database = new DatabaseIO().read((Reader)new InputStreamReader(fileUrl.openStream()));
                    Platform platform = this.dbDialect.getPlatform();
                    platform.createTables(database, false, true);
                    loaded = true;
                }
                catch (Exception e) {
                    this.log.error(e);
                }
            }
        }
        return loaded;
    }

    private boolean loadFromScriptIfProvided() {
        boolean loaded = false;
        String sqlScript = this.parameterService.getString("auto.config.registration.svr.sql.script");
        if (!StringUtils.isBlank((String)sqlScript)) {
            File file = new File(sqlScript);
            URL fileUrl = null;
            if (file.isFile()) {
                try {
                    fileUrl = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            } else {
                fileUrl = this.getClass().getResource(sqlScript);
                if (fileUrl == null) {
                    fileUrl = Thread.currentThread().getContextClassLoader().getResource(sqlScript);
                }
            }
            if (fileUrl != null) {
                new SqlScript(fileUrl, this.dataSource, true).execute();
                loaded = true;
            }
        }
        return loaded;
    }

    @Override
    public List<NodeGroupChannelWindow> getNodeGroupChannelWindows(String nodeGroupId, String channelId) {
        return this.jdbcTemplate.query(this.getSql("selectNodeGroupChannelWindowSql"), new Object[]{nodeGroupId, channelId}, (RowMapper)new NodeGroupChannelWindowMapper());
    }

    @Override
    public ChannelMap getSuspendIgnoreChannelLists(String nodeId) {
        ChannelMap map = new ChannelMap();
        List<NodeChannel> ncs = this.getNodeChannels(nodeId);
        for (NodeChannel nc : ncs) {
            if (nc.isSuspendEnabled()) {
                map.addSuspendChannels(nc.getChannelId());
            }
            if (!nc.isIgnoreEnabled()) continue;
            map.addIgnoreChannels(nc.getChannelId());
        }
        return map;
    }

    @Override
    public ChannelMap getSuspendIgnoreChannelLists() {
        return this.getSuspendIgnoreChannelLists(this.nodeService.findIdentityNodeId());
    }

    public void setDefaultChannels(List<Channel> defaultChannels) {
        this.defaultChannels = defaultChannels;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeGroupLinkMapper
    implements RowMapper<NodeGroupLink> {
        NodeGroupLinkMapper() {
        }

        public NodeGroupLink mapRow(ResultSet rs, int num) throws SQLException {
            NodeGroupLink node_groupTarget = new NodeGroupLink();
            node_groupTarget.setSourceNodeGroupId(rs.getString(1));
            node_groupTarget.setTargetNodeGroupId(rs.getString(2));
            node_groupTarget.setDataEventAction(NodeGroupLinkAction.fromCode(rs.getString(3)));
            return node_groupTarget;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeGroupChannelWindowMapper
    implements RowMapper<NodeGroupChannelWindow> {
        NodeGroupChannelWindowMapper() {
        }

        public NodeGroupChannelWindow mapRow(ResultSet rs, int rowNum) throws SQLException {
            NodeGroupChannelWindow window = new NodeGroupChannelWindow();
            window.setNodeGroupId(rs.getString(1));
            window.setChannelId(rs.getString(2));
            window.setStartTime(rs.getTime(3));
            window.setEndTime(rs.getTime(4));
            window.setEnabled(rs.getBoolean(5));
            return window;
        }
    }
}

