/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class ClusterService
extends AbstractService
implements IClusterService {
    protected String serverId = AppUtils.getServerId();

    public void initLockTable() {
        this.initLockTable("ROUTE", "common");
        this.initLockTable("PULL", "common");
        this.initLockTable("PUSH", "common");
        this.initLockTable("HEARTBEAT", "common");
        this.initLockTable("PURGE_INCOMING", "common");
        this.initLockTable("PURGE_OUTGOING", "common");
        this.initLockTable("PURGE_STATISTICS", "common");
        this.initLockTable("SYNCTRIGGERS", "common");
    }

    public void initLockTable(String action) {
        this.initLockTable(action, "common");
    }

    protected void initLockTable(String action, String lockId) {
        try {
            this.jdbcTemplate.update(this.getSql("insertLockSql"), new Object[]{lockId, action});
            this.log.debug("LockInserted", action);
        }
        catch (DataIntegrityViolationException ex) {
            this.log.debug("LockInsertFailed", action);
        }
    }

    public void clearAllLocks() {
        this.jdbcTemplate.update(this.getSql("clearAllLocksSql"));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean lock(String action) {
        return this.lock(action, "common");
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void unlock(String action) {
        this.unlock(action, "common");
    }

    protected boolean lock(String action, String id) {
        if (this.isClusteringEnabled()) {
            Date timeout = DateUtils.add((Date)new Date(), (int)14, (int)((int)(-this.parameterService.getLong("cluster.lock.timeout.ms"))));
            return this.jdbcTemplate.update(this.getSql("aquireLockSql"), new Object[]{this.serverId, id, action, timeout, this.serverId}) == 1;
        }
        return true;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    protected void unlock(String action, String id) {
        int count;
        if (this.isClusteringEnabled() && (count = this.jdbcTemplate.update(this.getSql("releaseLockSql"), new Object[]{id, action, this.serverId})) == 0) {
            this.log.warn("ClusterUnlockFailed", id, action, this.serverId);
        }
    }

    private boolean isClusteringEnabled() {
        return this.parameterService.is("cluster.lock.enabled");
    }
}

