/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.service.IBandwidthService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.transport.BandwidthTestResults;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;

public class BandwidthService
extends AbstractService
implements IBandwidthService {
    private IParameterService parameterService;

    public double getDownloadKbpsFor(String syncUrl, long sampleSize, long maxTestDuration) {
        double downloadSpeed = -1.0;
        try {
            BandwidthTestResults bw = this.getDownloadResultsFor(syncUrl, sampleSize, maxTestDuration);
            downloadSpeed = (int)bw.getKbps();
        }
        catch (SocketTimeoutException e) {
            this.log.warn("SocketTimeOut", syncUrl);
        }
        catch (Exception e) {
            this.log.error(e);
        }
        return downloadSpeed;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BandwidthTestResults getDownloadResultsFor(String syncUrl, long sampleSize, long maxTestDuration) throws IOException {
        BandwidthTestResults bandwidthTestResults;
        byte[] buffer = new byte[1024];
        InputStream is = null;
        try {
            int r;
            BandwidthTestResults bw = new BandwidthTestResults();
            URL u = new URL(String.format("%s/bandwidth?sampleSize=%s", syncUrl, sampleSize));
            bw.start();
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            this.setBasicAuthIfNeeded(conn);
            conn.connect();
            is = conn.getInputStream();
            while (-1 != (r = is.read(buffer)) && bw.getElapsed() <= maxTestDuration) {
                bw.transmitted(r);
            }
            is.close();
            bw.stop();
            this.log.info("BandwidthCalculated", syncUrl, bw.getKbps());
            bandwidthTestResults = bw;
            Object var14_11 = null;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return bandwidthTestResults;
    }

    protected void setBasicAuthIfNeeded(HttpURLConnection conn) {
        if (this.parameterService != null) {
            HttpTransportManager.setBasicAuthIfNeeded(conn, this.parameterService.getString("http.basic.auth.username"), this.parameterService.getString("http.basic.auth.password"));
        }
    }
}

