/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jumpmind.symmetric.io.IOfflineClientListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IOfflineDetectorService;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.SyncDisabledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOfflineDetectorService
extends AbstractService
implements IOfflineDetectorService {
    private List<IOfflineClientListener> offlineListeners;

    public void setOfflineListeners(List<IOfflineClientListener> listeners) {
        this.offlineListeners = listeners;
    }

    @Override
    public void addOfflineListener(IOfflineClientListener listener) {
        if (this.offlineListeners == null) {
            this.offlineListeners = new ArrayList<IOfflineClientListener>();
        }
        this.offlineListeners.add(listener);
    }

    @Override
    public boolean removeOfflineListener(IOfflineClientListener listener) {
        if (this.offlineListeners != null) {
            return this.offlineListeners.remove(listener);
        }
        return false;
    }

    protected void fireOffline(Exception error, Node remoteNode) {
        if (this.offlineListeners != null) {
            for (IOfflineClientListener listener : this.offlineListeners) {
                if (this.isOffline(error)) {
                    listener.offline(remoteNode);
                    continue;
                }
                if (this.isBusy(error)) {
                    listener.busy(remoteNode);
                    continue;
                }
                if (this.isNotAuthenticated(error)) {
                    listener.notAuthenticated(remoteNode);
                    continue;
                }
                if (this.isSyncDisabled(error)) {
                    listener.syncDisabled(remoteNode);
                    continue;
                }
                if (!this.isRegistrationRequired(error)) continue;
                listener.registrationRequired(remoteNode);
            }
        }
    }

    protected boolean isOffline(Exception ex) {
        boolean offline = false;
        if (ex != null) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            offline = cause instanceof SocketException || cause instanceof ConnectException;
        }
        return offline;
    }

    protected boolean isNotAuthenticated(Exception ex) {
        boolean offline = false;
        if (ex != null) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            offline = cause instanceof AuthenticationException;
        }
        return offline;
    }

    protected boolean isBusy(Exception ex) {
        boolean offline = false;
        if (ex != null) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            offline = cause instanceof ConnectionRejectedException;
        }
        return offline;
    }

    protected boolean isSyncDisabled(Exception ex) {
        Throwable cause;
        boolean syncDisabled = false;
        if (ex != null && !(syncDisabled = (cause = ExceptionUtils.getRootCause((Throwable)ex)) instanceof SyncDisabledException) && ex instanceof SyncDisabledException) {
            syncDisabled = true;
        }
        return syncDisabled;
    }

    protected boolean isRegistrationRequired(Exception ex) {
        Throwable cause;
        boolean registrationRequired = false;
        if (ex != null && !(registrationRequired = (cause = ExceptionUtils.getRootCause((Throwable)ex)) instanceof RegistrationRequiredException) && ex instanceof RegistrationRequiredException) {
            registrationRequired = true;
        }
        return registrationRequired;
    }
}

