/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jumpmind.symmetric.config.INodeIdGenerator;
import org.jumpmind.symmetric.ext.IOfflineServerListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.NodeStatus;
import org.jumpmind.symmetric.security.INodePasswordFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface INodeService {
    public Node findNode(String var1);

    public boolean isRegistrationServer();

    public Node findNodeByExternalId(String var1, String var2);

    public Set<Node> findNodesThatOriginatedFromNodeId(String var1);

    public Collection<Node> findEnabledNodesFromNodeGroup(String var1);

    public NodeSecurity findNodeSecurity(String var1);

    public NodeSecurity findNodeSecurity(String var1, boolean var2);

    public void deleteNodeSecurity(String var1);

    public String findSymmetricVersion();

    public String findIdentityNodeId();

    public void ignoreNodeChannelForExternalId(boolean var1, String var2, String var3, String var4);

    public boolean isNodeAuthorized(String var1, String var2);

    public void flushNodeAuthorizedCache();

    public boolean isRegistrationEnabled(String var1);

    public Node findIdentity();

    public Node findIdentity(boolean var1);

    public void deleteIdentity();

    public List<Node> findNodesToPull();

    public List<Node> findNodesToPushTo();

    public List<Node> findSourceNodesFor(NodeGroupLinkAction var1);

    public List<Node> findTargetNodesFor(NodeGroupLinkAction var1);

    public boolean isExternalIdRegistered(String var1, String var2);

    public void insertNode(String var1, String var2, String var3, String var4);

    public boolean updateNode(Node var1);

    public void updateNodeHostForCurrentNode();

    public void insertNodeIdentity(String var1);

    public void insertNodeGroup(String var1, String var2);

    public boolean updateNodeSecurity(NodeSecurity var1);

    public boolean setInitialLoadEnabled(String var1, boolean var2);

    public INodeIdGenerator getNodeIdGenerator();

    public void setNodeIdGenerator(INodeIdGenerator var1);

    public void setNodePasswordFilter(INodePasswordFilter var1);

    public boolean isDataLoadCompleted();

    public boolean isDataLoadStarted();

    public NodeStatus getNodeStatus();

    public void checkForOfflineNodes();

    public List<Node> findOfflineNodes();

    public void addOfflineServerListener(IOfflineServerListener var1);

    public boolean removeOfflineServerListener(IOfflineServerListener var1);
}

