/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.security.inet;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.security.inet.IInetAddressAuthorizerCompiler;
import org.jumpmind.symmetric.security.inet.IRawInetAddressAuthorizer;
import org.jumpmind.symmetric.security.inet.Inet4AddressAuthorizerCompiler;
import org.jumpmind.symmetric.security.inet.Inet6AddressAuthorizerCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddressAuthorizerCompiler
implements IInetAddressAuthorizerCompiler {
    Inet4AddressAuthorizerCompiler inet4Compiler = new Inet4AddressAuthorizerCompiler();
    Inet6AddressAuthorizerCompiler inet6Compiler = new Inet6AddressAuthorizerCompiler();

    @Override
    public List<IRawInetAddressAuthorizer> compile(String[] addresses) throws UnknownHostException {
        ArrayList<String> inet4Addrs = new ArrayList<String>();
        ArrayList<String> inet6Addrs = new ArrayList<String>();
        for (String filter : addresses) {
            if (filter.contains(":")) {
                inet6Addrs.add(filter);
                continue;
            }
            inet4Addrs.add(filter);
        }
        List<IRawInetAddressAuthorizer> rawFilters = this.inet4Compiler.compile(inet4Addrs.toArray(new String[inet4Addrs.size()]));
        rawFilters.addAll(this.inet6Compiler.compile(inet6Addrs.toArray(new String[inet6Addrs.size()])));
        return rawFilters;
    }
}

