/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.security.inet;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.security.inet.AbstractInetAddressAuthorizerCompiler;
import org.jumpmind.symmetric.security.inet.IRawInetAddressAuthorizer;

public class Inet4AddressAuthorizerCompiler
extends AbstractInetAddressAuthorizerCompiler {
    private static final ILog log = LogFactory.getLog(Inet4AddressAuthorizerCompiler.class);
    public static final String IPv4_OCTET_SEPARATOR = ".";
    public static final String BROADCAST_OCTET = "255";
    public static final int NUM_IPv4_OCTETS = 4;
    public static final short SHORT_MASK = 255;
    public static final byte ANY = -1;

    protected IRawInetAddressAuthorizer compileForIpVersion(String filter) throws UnknownHostException {
        filter = filter.trim();
        log.debug("FilterStringIPv4Compiling", filter);
        filter = this.replaceSymbols(filter);
        String[] octets = filter.split("\\.");
        if (octets.length != 4) {
            throw new IllegalArgumentException(String.format("Invalid IPv4 filter. Must have 4 octects separated by: '%s'. Provided: %s Length: %s", IPv4_OCTET_SEPARATOR, filter, octets.length));
        }
        log.debug("FilterRangeValuesChecking", filter);
        if (filter.contains("/")) {
            return this.compileCidrAuthorizer(filter);
        }
        if (filter.contains("-")) {
            return this.compileRangeAuthorizer(octets);
        }
        Inet4Address addr = (Inet4Address)InetAddress.getByName(filter);
        return new RawInet4AddressAuthorizer(addr.getAddress());
    }

    protected String getAddressSeparator() {
        return IPv4_OCTET_SEPARATOR;
    }

    protected String getBroadcastString() {
        return BROADCAST_OCTET;
    }

    protected short getOctetFromString(String octect) {
        short octetVal = Short.parseShort(octect);
        if (octetVal > 255 || octetVal < 0) {
            throw new IllegalArgumentException("Invalid IPv4 octect: " + octetVal);
        }
        return octetVal;
    }

    public static short[] convertAddressBytesToShort(byte[] bytes) {
        short[] retVal = new short[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            retVal[i] = (short)(0xFF & bytes[i]);
        }
        return retVal;
    }

    public static byte[] convertShortToAddressBytes(short[] shorts) {
        byte[] retVal = new byte[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            retVal[i] = (byte)shorts[i];
        }
        return retVal;
    }

    private RawInet4AddressRangeAuthorizer compileRangeAuthorizer(String[] octets) throws UnknownHostException {
        short[] startRange = new short[4];
        short[] endRange = new short[4];
        for (int i = 0; i < octets.length; ++i) {
            short singleVal;
            if (octets[i].contains("-")) {
                short lowerBounds;
                String[] range = octets[i].split("-");
                if (range.length != 2) {
                    throw new IllegalArgumentException("Illegal range pattern for filter address octet. Provided: " + octets[i]);
                }
                short upperBounds = this.getOctetFromString(range[0]);
                if (upperBounds < (lowerBounds = this.getOctetFromString(range[1]))) {
                    throw new IllegalArgumentException("Byte Range must be specificed as '<higher bounds>-<lower bounds>'. Provided: " + octets[i]);
                }
                startRange[i] = lowerBounds;
                endRange[i] = upperBounds;
                continue;
            }
            startRange[i] = singleVal = this.getOctetFromString(octets[i]);
            endRange[i] = singleVal;
        }
        InetAddress.getByAddress(Inet4AddressAuthorizerCompiler.convertShortToAddressBytes(startRange));
        InetAddress.getByAddress(Inet4AddressAuthorizerCompiler.convertShortToAddressBytes(endRange));
        return new RawInet4AddressRangeAuthorizer(startRange, endRange);
    }

    private RawInet4AddressCidrAuthorizer compileCidrAuthorizer(String filter) throws UnknownHostException {
        if (filter.contains("-") || filter.contains("*")) {
            throw new IllegalArgumentException("CIDR formatted filters cannot contain other tokens");
        }
        String[] cidrNotation = filter.split("/", 2);
        if (cidrNotation.length != 2) {
            throw new IllegalArgumentException("Expected format of CIDR string is '###.###.###.###/##'");
        }
        InetAddress inetAddr = InetAddress.getByName(cidrNotation[0]);
        byte significantBits = Byte.parseByte(cidrNotation[1]);
        return new RawInet4AddressCidrAuthorizer(inetAddr.getAddress(), significantBits);
    }

    static class RawInet4AddressAuthorizer
    implements IRawInetAddressAuthorizer {
        private final byte[] checkAddress;

        RawInet4AddressAuthorizer(byte[] address) {
            this.checkAddress = address;
        }

        public boolean isAuthorized(byte[] addrBytes) {
            for (int i = 0; i < addrBytes.length; ++i) {
                if (this.checkAddress[i] == -1 || addrBytes[i] == this.checkAddress[i]) continue;
                return false;
            }
            return true;
        }
    }

    static class RawInet4AddressCidrAuthorizer
    implements IRawInetAddressAuthorizer {
        private final int checkAddress;
        private int cidrMask = Integer.MIN_VALUE;
        private final byte significantBits;

        RawInet4AddressCidrAuthorizer(byte[] address, byte signifcantBits) {
            if (signifcantBits < 0 || signifcantBits > 32) {
                throw new IllegalArgumentException(String.format("Invalid CIDR Notation '/%s'. Values must be 0-32.", signifcantBits));
            }
            this.cidrMask >>= signifcantBits - 1;
            this.checkAddress = this.bytesToCidrInt(address);
            this.significantBits = signifcantBits;
        }

        public boolean isAuthorized(byte[] addrBytes) {
            if (this.significantBits == 0) {
                return true;
            }
            int convertedAddress = this.bytesToCidrInt(addrBytes);
            return (convertedAddress & this.checkAddress) == convertedAddress;
        }

        private int bytesToCidrInt(byte[] address) {
            if (address == null || address.length != 4) {
                return 0;
            }
            int addressAsInt = 0;
            addressAsInt = address[3] & 0xFF;
            addressAsInt |= address[2] << 8 & 0xFF00;
            addressAsInt |= address[1] << 16 & 0xFF0000;
            return (addressAsInt |= address[0] << 24 & 0xFF000000) & this.cidrMask;
        }
    }

    static class RawInet4AddressRangeAuthorizer
    implements IRawInetAddressAuthorizer {
        private final short[] startAddress;
        private final short[] endAddress;

        RawInet4AddressRangeAuthorizer(short[] startAddress, short[] endAddress) {
            if (startAddress.length != 4 || endAddress.length != 4) {
                throw new IllegalArgumentException("Invalid number of octets in IPv4 address filter");
            }
            this.startAddress = startAddress;
            this.endAddress = endAddress;
        }

        public boolean isAuthorized(byte[] addrBytes) {
            short[] addrAsShorts = Inet4AddressAuthorizerCompiler.convertAddressBytesToShort(addrBytes);
            for (int i = 0; i < addrAsShorts.length; ++i) {
                if (this.startAddress[i] == 255 || addrAsShorts[i] >= this.startAddress[i] && addrAsShorts[i] <= this.endAddress[i]) continue;
                return false;
            }
            return true;
        }
    }
}

