/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.security.inet;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.security.inet.IInetAddressAuthorizerCompiler;
import org.jumpmind.symmetric.security.inet.IRawInetAddressAuthorizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInetAddressAuthorizerCompiler
implements IInetAddressAuthorizerCompiler {
    public static final String ANY_TOKEN = "*";
    public static final String RANGE_TOKEN = "-";
    public static final String CIDR_TOKEN = "/";
    private static final ILog log = LogFactory.getLog(AbstractInetAddressAuthorizerCompiler.class);

    @Override
    public List<IRawInetAddressAuthorizer> compile(String[] filterStrings) throws UnknownHostException {
        ArrayList<IRawInetAddressAuthorizer> rawFilters = new ArrayList<IRawInetAddressAuthorizer>();
        for (String filter : filterStrings) {
            log.debug("FilterStringCompiling", filter);
            rawFilters.add(this.compileForIpVersion(filter));
        }
        return rawFilters;
    }

    protected String replaceSymbols(String filter) {
        if (filter.contains(ANY_TOKEN)) {
            String[] octets;
            for (String octet : octets = filter.split(this.getAddressSeparator())) {
                if (!octet.contains(ANY_TOKEN) || octet.length() <= 1) continue;
                throw new IllegalArgumentException(String.format("Illegal wild card. '%s' can be the the only char in the address piece. Provided: '%s'", ANY_TOKEN, octet));
            }
            filter = filter.replaceAll("\\*", this.getBroadcastString());
            log.debug("FilterReplaced", filter);
        }
        return filter;
    }

    protected abstract IRawInetAddressAuthorizer compileForIpVersion(String var1) throws UnknownHostException;

    protected abstract String getBroadcastString();

    protected abstract String getAddressSeparator();
}

