/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.route.IRouterContext;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRouterContext
implements IRouterContext {
    protected NodeChannel channel;
    protected JdbcTemplate jdbcTemplate;
    protected boolean encountedTransactionBoundary = false;
    protected Map<String, Object> contextCache = new HashMap<String, Object>();
    protected String nodeId;

    public SimpleRouterContext(String nodeId, JdbcTemplate jdbcTemplate, NodeChannel channel) {
        this.init(jdbcTemplate, channel, nodeId);
    }

    public SimpleRouterContext() {
    }

    protected void init(JdbcTemplate jdbcTemplate, NodeChannel channel, String nodeId) {
        this.channel = channel;
        this.jdbcTemplate = jdbcTemplate;
        this.nodeId = nodeId;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public NodeChannel getChannel() {
        return this.channel;
    }

    @Override
    public Map<String, Object> getContextCache() {
        return this.contextCache;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setEncountedTransactionBoundary(boolean encountedTransactionBoundary) {
        this.encountedTransactionBoundary = encountedTransactionBoundary;
    }

    @Override
    public boolean isEncountedTransactionBoundary() {
        return this.encountedTransactionBoundary;
    }

    private final String getStatKey(String name) {
        return String.format("Stat.%s", name);
    }

    @Override
    public synchronized void incrementStat(long amount, String name) {
        String KEY = this.getStatKey(name);
        Long val = (Long)this.contextCache.get(KEY);
        if (val == null) {
            val = 0L;
        }
        val = val + amount;
        this.contextCache.put(KEY, val);
    }

    public long getStat(String name) {
        String KEY = this.getStatKey(name);
        Long val = (Long)this.contextCache.get(KEY);
        if (val == null) {
            val = 0L;
        }
        return val;
    }

    public void logStats(ILog log, int dataCount, long totalTimeInMs) {
        boolean infoLevel = totalTimeInMs > 30000L;
        HashSet<String> keys = new HashSet<String>(this.contextCache.keySet());
        for (String key : keys) {
            if (!key.startsWith("Stat.")) continue;
            String keyString = key.substring(key.indexOf(".") + 1);
            if (infoLevel) {
                log.info("RouterStats", this.channel.getChannelId(), keyString, this.contextCache.get(key));
                continue;
            }
            log.debug("RouterStats", this.channel.getChannelId(), keyString, this.contextCache.get(key));
        }
        if (infoLevel) {
            log.info("RouterTimeForChannel", totalTimeInMs, dataCount, this.channel.getChannelId());
        } else {
            log.debug("RouterTimeForChannel", totalTimeInMs, dataCount, this.channel.getChannelId());
        }
    }
}

