/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEvent;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterContext
extends SimpleRouterContext
implements IRouterContext {
    static final ILog log = LogFactory.getLog(RouterContext.class);
    public static final String STAT_INSERT_DATA_EVENTS_MS = "insert.data.events.ms";
    public static final String STAT_DATA_ROUTER_MS = "data.router.ms";
    public static final String STAT_READ_DATA_MS = "read.data.ms";
    public static final String STAT_REREAD_DATA_MS = "already.read.data.ms";
    public static final String STAT_READ_RESULT_WAIT_TIME_MS = "read.result.wait.time.ms";
    public static final String STAT_ENQUEUE_DATA_MS = "enqueue.data.ms";
    public static final String STAT_ENQUEUE_EOD_MS = "enqueue.eod.data.ms";
    private Map<String, OutgoingBatch> batchesByNodes = new HashMap<String, OutgoingBatch>();
    private Map<TriggerRouter, Set<Node>> availableNodes = new HashMap<TriggerRouter, Set<Node>>();
    private Set<IDataRouter> usedDataRouters = new HashSet<IDataRouter>();
    private Connection connection;
    private boolean needsCommitted = false;
    private long createdTimeInMs = System.currentTimeMillis();
    private Map<String, Long> transactionIdDataIds = new HashMap<String, Long>();
    private boolean oldAutoCommitSetting = false;
    private List<DataEvent> dataEventsToSend = new ArrayList<DataEvent>();

    public RouterContext(String nodeId, NodeChannel channel, DataSource dataSource) throws SQLException {
        this.connection = dataSource.getConnection();
        this.oldAutoCommitSetting = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        this.init(new JdbcTemplate((DataSource)new SingleConnectionDataSource(this.connection, true)), channel, nodeId);
    }

    public List<DataEvent> getDataEventList() {
        return this.dataEventsToSend;
    }

    public void clearDataEventsList() {
        this.dataEventsToSend.clear();
    }

    public void addDataEvent(long dataId, long batchId, String routerId) {
        this.dataEventsToSend.add(new DataEvent(dataId, batchId, routerId));
    }

    public Map<String, OutgoingBatch> getBatchesByNodes() {
        return this.batchesByNodes;
    }

    public Map<TriggerRouter, Set<Node>> getAvailableNodes() {
        return this.availableNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        try {
            this.connection.commit();
            Object var2_1 = null;
            this.clearState();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clearState();
            throw throwable;
        }
    }

    protected void clearState() {
        this.usedDataRouters.clear();
        this.encountedTransactionBoundary = false;
        this.batchesByNodes.clear();
        this.availableNodes.clear();
        this.dataEventsToSend.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                LogFactory.getLog(this.getClass()).warn(e);
                Object var3_2 = null;
                this.clearState();
            }
            Object var3_1 = null;
            this.clearState();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.clearState();
            throw throwable;
        }
    }

    public void cleanup() {
        try {
            this.connection.commit();
            this.connection.setAutoCommit(this.oldAutoCommitSetting);
        }
        catch (Exception ex) {
            log.warn(ex);
        }
        JdbcUtils.closeConnection((Connection)this.connection);
    }

    public void setNeedsCommitted(boolean b) {
        this.needsCommitted = b;
    }

    public boolean isNeedsCommitted() {
        return this.needsCommitted;
    }

    public Set<IDataRouter> getUsedDataRouters() {
        return this.usedDataRouters;
    }

    public void addUsedDataRouter(IDataRouter dataRouter) {
        this.usedDataRouters.add(dataRouter);
    }

    public void resetForNextData() {
        this.needsCommitted = false;
    }

    public long getCreatedTimeInMs() {
        return this.createdTimeInMs;
    }

    public void setLastDataIdForTransactionId(Data data) {
        if (data.getTransactionId() != null) {
            this.transactionIdDataIds.put(data.getTransactionId(), data.getDataId());
        }
    }

    public void recordTransactionBoundaryEncountered(Data data) {
        Long dataId = this.transactionIdDataIds.get(data.getTransactionId());
        this.setEncountedTransactionBoundary(dataId == null ? true : dataId.longValue() == data.getDataId());
    }
}

