/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupTableDataRouter
extends AbstractDataRouter
implements IDataRouter {
    static final ILog log = LogFactory.getLog(LookupTableDataRouter.class);
    public static final String PARAM_TABLE = "LOOKUP_TABLE";
    public static final String PARAM_KEY_COLUMN = "KEY_COLUMN";
    public static final String PARAM_MAPPED_KEY_COLUMN = "LOOKUP_KEY_COLUMN";
    public static final String PARAM_EXTERNAL_ID_COLUMN = "EXTERNAL_ID_COLUMN";
    static final String EXPRESSION_KEY = String.format("%s.Expression.", LookupTableDataRouter.class.getName());
    static final String LOOKUP_TABLE_KEY = String.format("%s.Table.", LookupTableDataRouter.class.getName());
    private JdbcTemplate jdbcTemplate;

    @Override
    public Collection<String> routeToNodes(IRouterContext routingContext, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad) {
        boolean validExpression;
        Set<String> nodeIds = null;
        Router router = dataMetaData.getTriggerRouter().getRouter();
        Map<String, String> params = this.getParams(router, routingContext);
        Map<String, String> dataMap = this.getDataMap(dataMetaData);
        boolean bl = validExpression = params.containsKey(PARAM_TABLE) && params.containsKey(PARAM_KEY_COLUMN) && params.containsKey(PARAM_MAPPED_KEY_COLUMN) && params.containsKey(PARAM_EXTERNAL_ID_COLUMN);
        if (validExpression) {
            String column;
            String keyData;
            Map<String, Set<String>> lookupTable = this.getLookupTable(params, router, routingContext);
            Set<String> externalIds = lookupTable.get(keyData = dataMap.get(column = params.get(PARAM_KEY_COLUMN)));
            if (externalIds != null) {
                for (Node node : nodes) {
                    if (!externalIds.contains(node.getExternalId())) continue;
                    nodeIds = this.addNodeId(node.getNodeId(), nodeIds, nodes);
                }
            }
        } else {
            log.warn("RouterIllegalLookupTableExpression", router.getRouterExpression());
        }
        return nodeIds;
    }

    protected Map<String, String> getParams(Router router, IRouterContext routingContext) {
        String KEY = EXPRESSION_KEY + router.getRouterId();
        HashMap<String, String> params = (HashMap<String, String>)routingContext.getContextCache().get(KEY);
        if (params == null) {
            String[] expTokens;
            params = new HashMap<String, String>();
            routingContext.getContextCache().put(KEY, params);
            String routerExpression = router.getRouterExpression();
            if (!StringUtils.isBlank((String)routerExpression) && (expTokens = routerExpression.split("\r\n|\r|\n")) != null) {
                for (String t : expTokens) {
                    String[] tokens;
                    if (StringUtils.isBlank((String)t) || (tokens = t.split("=")).length < 2) continue;
                    params.put(tokens[0], tokens[1]);
                }
            }
        }
        return params;
    }

    protected Map<String, Set<String>> getLookupTable(Map<String, String> params, Router router, IRouterContext routingContext) {
        String CTX_CACHE_KEY = LOOKUP_TABLE_KEY + "." + params.get("TABLENAME");
        HashMap lookupMap = (HashMap)routingContext.getContextCache().get(CTX_CACHE_KEY);
        if (lookupMap == null) {
            final HashMap fillMap = new HashMap();
            this.jdbcTemplate.query(String.format("select %s, %s from %s", params.get(PARAM_MAPPED_KEY_COLUMN), params.get(PARAM_EXTERNAL_ID_COLUMN), params.get(PARAM_TABLE)), new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    String key = rs.getString(1);
                    HashSet<String> set = (HashSet<String>)fillMap.get(key);
                    if (set == null) {
                        set = new HashSet<String>();
                        fillMap.put(key, set);
                    }
                    set.add(rs.getString(2));
                }
            });
            lookupMap = fillMap;
            routingContext.getContextCache().put(CTX_CACHE_KEY, lookupMap);
        }
        return lookupMap;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

