/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;
import org.jumpmind.symmetric.service.IRegistrationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnMatchDataRouter
extends AbstractDataRouter
implements IDataRouter {
    private static final String NULL_VALUE = "NULL";
    private IRegistrationService registrationService;
    static final String EXPRESSION_KEY = String.format("%s.Expression.", ColumnMatchDataRouter.class.getName());

    @Override
    public Collection<String> routeToNodes(IRouterContext routingContext, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad) {
        Set<String> nodeIds = null;
        List<Expression> expressions = this.getExpressions(dataMetaData.getTriggerRouter().getRouter(), routingContext);
        Map<String, String> columnValues = this.getDataMap(dataMetaData);
        if (columnValues != null) {
            for (Expression e : expressions) {
                String column = e.tokens[0].trim();
                String value = e.tokens[1];
                if (value.equalsIgnoreCase(":NODE_ID")) {
                    for (Node node : nodes) {
                        if (!e.equals || !node.getNodeId().equals(columnValues.get(column))) continue;
                        nodeIds = this.addNodeId(node.getNodeId(), nodeIds, nodes);
                    }
                    continue;
                }
                if (value.equalsIgnoreCase(":EXTERNAL_ID")) {
                    for (Node node : nodes) {
                        if (!e.equals || !node.getExternalId().equals(columnValues.get(column))) continue;
                        nodeIds = this.addNodeId(node.getNodeId(), nodeIds, nodes);
                    }
                    continue;
                }
                if (value.equalsIgnoreCase(":NODE_GROUP_ID")) {
                    for (Node node : nodes) {
                        if (!e.equals || !node.getNodeGroupId().equals(columnValues.get(column))) continue;
                        nodeIds = this.addNodeId(node.getNodeId(), nodeIds, nodes);
                    }
                    continue;
                }
                if (e.equals && value.equalsIgnoreCase(":REDIRECT_NODE")) {
                    Map<String, String> redirectMap = this.getRedirectMap(routingContext);
                    String nodeId = redirectMap.get(columnValues.get(column));
                    if (nodeId == null) continue;
                    nodeIds = this.addNodeId(nodeId, nodeIds, nodes);
                    continue;
                }
                if (value.startsWith(":")) {
                    String firstValue = columnValues.get(column);
                    String secondValue = columnValues.get(value.substring(1));
                    if (e.equals && (firstValue == null && secondValue == null || firstValue != null && secondValue != null && firstValue.equals(secondValue))) {
                        nodeIds = this.toNodeIds(nodes, nodeIds);
                        continue;
                    }
                    if (e.equals || !(firstValue != null && secondValue == null || firstValue == null && secondValue != null) && (firstValue == null || secondValue == null || firstValue.equals(secondValue))) continue;
                    nodeIds = this.toNodeIds(nodes, nodeIds);
                    continue;
                }
                if (e.equals && (value.equals(columnValues.get(column)) || value.equals(NULL_VALUE) && columnValues.get(column) == null)) {
                    nodeIds = this.toNodeIds(nodes, nodeIds);
                    continue;
                }
                if (e.equals || (value.equals(NULL_VALUE) || value.equals(columnValues.get(column))) && (!value.equals(NULL_VALUE) || columnValues.get(column) == null)) continue;
                nodeIds = this.toNodeIds(nodes, nodeIds);
            }
        } else {
            this.log.warn("RouterNoColumnsToMatch", dataMetaData.getData().getDataId());
        }
        return nodeIds;
    }

    protected List<Expression> getExpressions(Router router, IRouterContext context) {
        String KEY = EXPRESSION_KEY + router.getRouterId();
        ArrayList<Expression> expressions = (ArrayList<Expression>)context.getContextCache().get(KEY);
        if (expressions == null) {
            expressions = new ArrayList<Expression>();
            String routerExpression = router.getRouterExpression();
            if (!StringUtils.isBlank((String)routerExpression)) {
                context.getContextCache().put(KEY, expressions);
                String[] expTokens = routerExpression.split("\r\n|\r|\n");
                if (expTokens != null) {
                    for (String t : expTokens) {
                        if (StringUtils.isBlank((String)t)) continue;
                        String[] tokens = null;
                        boolean equals = !t.contains("!=");
                        tokens = !equals ? t.split("!=") : t.split("=");
                        if (tokens.length == 2) {
                            expressions.add(new Expression(equals, tokens));
                            continue;
                        }
                        this.log.warn("RouterIllegalColumnMatchExpression", t, routerExpression);
                    }
                }
            } else {
                this.log.warn("RouterIllegalColumnMatchExpression", routerExpression, routerExpression);
            }
        }
        return expressions;
    }

    protected Map<String, String> getRedirectMap(IRouterContext ctx) {
        String CTX_CACHE_KEY = ColumnMatchDataRouter.class.getSimpleName() + "RouterMap";
        Map<String, String> redirectMap = (Map<String, String>)ctx.getContextCache().get(CTX_CACHE_KEY);
        if (redirectMap == null) {
            redirectMap = this.registrationService.getRegistrationRedirectMap();
            ctx.getContextCache().put(CTX_CACHE_KEY, redirectMap);
        }
        return redirectMap;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    class Expression {
        boolean equals;
        String[] tokens;

        public Expression(boolean equals, String[] tokens) {
            this.equals = equals;
            this.tokens = tokens;
        }
    }
}

