/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BshDataRouter
extends AbstractDataRouter {
    protected IDbDialect dbDialect;
    final String INTERPRETER_KEY = String.format("%d.BshInterpreter", this.hashCode());

    @Override
    public Collection<String> routeToNodes(IRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad) {
        try {
            long ts = System.currentTimeMillis();
            Interpreter interpreter = this.getInterpreter(context);
            context.incrementStat(System.currentTimeMillis() - ts, "bsh.init.ms");
            HashSet<String> targetNodes = new HashSet<String>();
            ts = System.currentTimeMillis();
            this.bind(interpreter, dataMetaData, nodes, targetNodes);
            context.incrementStat(System.currentTimeMillis() - ts, "bsh.bind.ms");
            ts = System.currentTimeMillis();
            Object returnValue = interpreter.eval(dataMetaData.getTriggerRouter().getRouter().getRouterExpression());
            context.incrementStat(System.currentTimeMillis() - ts, "bsh.eval.ms");
            return this.eval(returnValue, nodes, targetNodes);
        }
        catch (EvalError e) {
            this.log.error("RouterGeneralError", e);
            return Collections.emptySet();
        }
    }

    protected Interpreter getInterpreter(IRouterContext context) {
        Interpreter interpreter = (Interpreter)context.getContextCache().get(this.INTERPRETER_KEY);
        if (interpreter == null) {
            interpreter = new Interpreter();
            context.getContextCache().put(this.INTERPRETER_KEY, interpreter);
        }
        return interpreter;
    }

    protected Collection<String> eval(Object value, Set<Node> nodes, Set<String> targetNodes) {
        if (targetNodes.size() > 0) {
            return targetNodes;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            HashSet<String> nodeIds = new HashSet<String>(values.size());
            for (Object v : values) {
                if (v == null) continue;
                nodeIds.add(v.toString());
            }
            return nodeIds;
        }
        if (value instanceof Boolean && value.equals(Boolean.TRUE)) {
            return this.toNodeIds(nodes, null);
        }
        if (value instanceof String) {
            HashSet<String> node = new HashSet<String>(1);
            node.add(value.toString());
            return node;
        }
        return Collections.emptySet();
    }

    protected void bind(Interpreter interpreter, DataMetaData dataMetaData, Set<Node> nodes, Set<String> targetNodes) throws EvalError {
        interpreter.set("nodes", nodes);
        interpreter.set("targetNodes", targetNodes);
        Map<String, Object> params = this.getDataObjectMap(dataMetaData, this.dbDialect);
        if (params != null) {
            for (String param : params.keySet()) {
                interpreter.set(param, params.get(param));
            }
        }
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }
}

