/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataRouter
implements IDataRouter {
    private static final String OLD_ = "OLD_";
    protected final ILog log = LogFactory.getLog(this.getClass());
    private boolean autoRegister = true;

    @Override
    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    protected Map<String, String> getDataMap(DataMetaData dataMetaData) {
        HashMap<String, String> data = null;
        DataEventType dml = dataMetaData.getData().getEventType();
        switch (dml) {
            case UPDATE: {
                data = new HashMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(this.getNewDataAsString(null, dataMetaData));
                data.putAll(this.getOldDataAsString(OLD_, dataMetaData));
                break;
            }
            case INSERT: {
                data = new HashMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(this.getNewDataAsString(null, dataMetaData));
                Map map = this.getNullData(OLD_, dataMetaData);
                data.putAll(map);
                break;
            }
            case DELETE: {
                data = new HashMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(this.getOldDataAsString(null, dataMetaData));
                data.putAll(this.getOldDataAsString(OLD_, dataMetaData));
                break;
            }
            default: {
                data = new HashMap<String, String>(1);
            }
        }
        if (data.size() == 0) {
            data.putAll(this.getPkDataAsString(dataMetaData));
        }
        data.put("EXTERNAL_DATA", dataMetaData.getData().getExternalData());
        return data;
    }

    protected Map<String, String> getNewDataAsString(String prefix, DataMetaData dataMetaData) {
        String[] rowData = dataMetaData.getData().toParsedRowData();
        return this.getDataAsString(prefix, dataMetaData, rowData);
    }

    protected Map<String, String> getOldDataAsString(String prefix, DataMetaData dataMetaData) {
        String[] rowData = dataMetaData.getData().toParsedOldData();
        return this.getDataAsString(prefix, dataMetaData, rowData);
    }

    protected Map<String, String> getDataAsString(String prefix, DataMetaData dataMetaData, String[] rowData) {
        String[] columns = dataMetaData.getTriggerHistory().getParsedColumnNames();
        HashMap<String, String> map = new HashMap<String, String>(columns.length);
        if (rowData != null) {
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].toUpperCase();
                map.put(prefix != null ? prefix + columnName : columnName, rowData[i]);
            }
        }
        return map;
    }

    protected Map<String, String> getPkDataAsString(DataMetaData dataMetaData) {
        String[] columns = dataMetaData.getTriggerHistory().getParsedPkColumnNames();
        String[] rowData = dataMetaData.getData().toParsedPkData();
        HashMap<String, String> map = new HashMap<String, String>(columns.length);
        if (rowData != null) {
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].toUpperCase();
                map.put(columnName, rowData[i]);
            }
        }
        return map;
    }

    protected Map<String, Object> getDataObjectMap(DataMetaData dataMetaData, IDbDialect dbDialect) {
        HashMap<String, Object> data = null;
        DataEventType dml = dataMetaData.getData().getEventType();
        switch (dml) {
            case UPDATE: {
                data = new HashMap<String, Object>(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(this.getNewDataAsObject(null, dataMetaData, dbDialect));
                data.putAll(this.getOldDataAsObject(OLD_, dataMetaData, dbDialect));
                break;
            }
            case INSERT: {
                data = new HashMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(this.getNewDataAsObject(null, dataMetaData, dbDialect));
                Map map = this.getNullData(OLD_, dataMetaData);
                data.putAll(map);
                break;
            }
            case DELETE: {
                data = new HashMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(this.getOldDataAsObject(null, dataMetaData, dbDialect));
                data.putAll(this.getOldDataAsObject(OLD_, dataMetaData, dbDialect));
                if (data.size() != 0) break;
                data.putAll(this.getPkDataAsObject(dataMetaData, dbDialect));
                break;
            }
        }
        return data;
    }

    protected Map<String, Object> getNewDataAsObject(String prefix, DataMetaData dataMetaData, IDbDialect dbDialect) {
        return this.getDataAsObject(prefix, dataMetaData, dbDialect, dataMetaData.getData().toParsedRowData());
    }

    protected Map<String, Object> getOldDataAsObject(String prefix, DataMetaData dataMetaData, IDbDialect dbDialect) {
        return this.getDataAsObject(prefix, dataMetaData, dbDialect, dataMetaData.getData().toParsedOldData());
    }

    protected <T> Map<String, T> getNullData(String prefix, DataMetaData dataMetaData) {
        String[] columnNames = dataMetaData.getTriggerHistory().getParsedColumnNames();
        HashMap<String, Object> data = new HashMap<String, Object>(columnNames.length);
        for (String columnName : columnNames) {
            data.put(prefix != null ? prefix + columnName : columnName, null);
        }
        return data;
    }

    protected Map<String, Object> getDataAsObject(String prefix, DataMetaData dataMetaData, IDbDialect dbDialect, String[] rowData) {
        if (rowData != null) {
            HashMap<String, Object> data = new HashMap<String, Object>(rowData.length);
            String[] columnNames = dataMetaData.getTriggerHistory().getParsedColumnNames();
            Object[] objects = dbDialect.getObjectValues(dbDialect.getBinaryEncoding(), dataMetaData.getTable(), columnNames, rowData);
            for (int i = 0; i < columnNames.length; ++i) {
                data.put(prefix != null ? (prefix + columnNames[i]).toUpperCase() : columnNames[i].toUpperCase(), objects[i]);
            }
            return data;
        }
        return Collections.emptyMap();
    }

    protected Map<String, Object> getPkDataAsObject(DataMetaData dataMetaData, IDbDialect dbDialect) {
        String[] rowData = dataMetaData.getData().toParsedPkData();
        if (rowData != null) {
            HashMap<String, Object> data = new HashMap<String, Object>(rowData.length);
            String[] columnNames = dataMetaData.getTriggerHistory().getParsedColumnNames();
            Object[] objects = dbDialect.getObjectValues(dbDialect.getBinaryEncoding(), dataMetaData.getTable(), columnNames, rowData);
            for (int i = 0; i < columnNames.length; ++i) {
                data.put(columnNames[i].toUpperCase(), objects[i]);
            }
            return data;
        }
        return Collections.emptyMap();
    }

    protected Set<String> addNodeId(String nodeId, Set<String> nodeIds, Set<Node> nodes) {
        nodeIds = nodeIds == null ? new HashSet<String>(1) : nodeIds;
        for (Node node : nodes) {
            if (!node.getNodeId().equals(nodeId)) continue;
            nodeIds.add(nodeId);
            break;
        }
        return nodeIds;
    }

    protected Set<String> toNodeIds(Set<Node> nodes, Set<String> nodeIds) {
        nodeIds = nodeIds == null ? new HashSet<String>(nodes.size()) : nodeIds;
        for (Node node : nodes) {
            nodeIds.add(node.getNodeId());
        }
        return nodeIds;
    }

    protected Set<String> toExternalIds(Set<Node> nodes) {
        HashSet<String> externalIds = new HashSet<String>();
        for (Node node : nodes) {
            externalIds.add(node.getExternalId());
        }
        return externalIds;
    }

    @Override
    public void completeBatch(IRouterContext context, OutgoingBatch batch) {
        this.log.debug("BatchCompleting", batch.getBatchId());
    }
}

