/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;

public class TriggerRouter {
    static final Log logger = LogFactory.getLog(TriggerRouter.class);
    private static final long serialVersionUID = 8947288471097851573L;
    private int initialLoadOrder;
    private String initialLoadSelect;
    private Trigger trigger = new Trigger();
    private Router router = new Router();
    private Date createTime = new Date();
    private Date lastUpdateTime = new Date();
    private String lastUpdateBy;

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setCreateTime(Date createdOn) {
        this.createTime = createdOn;
    }

    public void setLastUpdateTime(Date lastModifiedOn) {
        this.lastUpdateTime = lastModifiedOn;
    }

    public void setLastUpdateBy(String updatedBy) {
        this.lastUpdateBy = updatedBy;
    }

    public Column[] orderColumnsForTable(Table table) {
        return this.trigger.orderColumnsForTable(table);
    }

    public int getInitialLoadOrder() {
        return this.initialLoadOrder;
    }

    public void setInitialLoadOrder(int order) {
        this.initialLoadOrder = order;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setInitialLoadSelect(String initialLoadSelect) {
        this.initialLoadSelect = initialLoadSelect;
    }

    public String getInitialLoadSelect() {
        return this.initialLoadSelect;
    }

    public boolean isRouted(DataEventType event) {
        switch (event) {
            case INSERT: {
                return this.router.isSyncOnInsert();
            }
            case DELETE: {
                return this.router.isSyncOnDelete();
            }
            case UPDATE: {
                return this.router.isSyncOnUpdate();
            }
        }
        return true;
    }

    public String getTargetSchema(String defaultSchema) {
        if (this.router != null && !StringUtils.isBlank((String)this.router.getTargetSchemaName())) {
            return this.router.getTargetSchemaName();
        }
        if (this.trigger != null && !StringUtils.isBlank((String)this.trigger.getSourceSchemaName())) {
            return this.trigger.getSourceSchemaName();
        }
        return defaultSchema;
    }

    public String getTargetCatalog(String defaultCatalog) {
        if (this.router != null && !StringUtils.isBlank((String)this.router.getTargetCatalogName())) {
            return this.router.getTargetCatalogName();
        }
        if (this.trigger != null && !StringUtils.isBlank((String)this.trigger.getSourceCatalogName())) {
            return this.trigger.getSourceCatalogName();
        }
        return defaultCatalog;
    }

    public String getTargetTable() {
        if (this.router != null && !StringUtils.isBlank((String)this.router.getTargetTableName())) {
            return this.router.getTargetTableName();
        }
        if (this.trigger != null && !StringUtils.isBlank((String)this.trigger.getSourceTableName())) {
            return this.trigger.getSourceTableName();
        }
        return null;
    }

    public String getQualifiedTargetTableName() {
        String catalog = this.getTargetCatalog(null);
        String schema = this.getTargetSchema(null);
        String tableName = this.getTargetTable();
        if (!StringUtils.isBlank((String)schema)) {
            tableName = schema + "." + tableName;
        }
        if (!StringUtils.isBlank((String)catalog)) {
            tableName = catalog + "." + tableName;
        }
        return tableName;
    }

    public boolean isSame(TriggerRouter triggerRouter) {
        return this.trigger == null && triggerRouter.trigger == null || this.trigger != null && triggerRouter.trigger != null && this.trigger.isSame(triggerRouter.trigger) && this.router == null && triggerRouter.router == null || this.router != null && triggerRouter.router != null && this.router.equals(triggerRouter.router);
    }
}

