/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.model.AbstractCsvData;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerReBuildReason;

public class TriggerHistory
extends AbstractCsvData {
    private int triggerHistoryId;
    private String triggerId;
    private String sourceTableName;
    private String sourceSchemaName;
    private String sourceCatalogName;
    private Date createTime;
    private String columnNames;
    private String pkColumnNames;
    private String nameForInsertTrigger;
    private String nameForUpdateTrigger;
    private String nameForDeleteTrigger;
    private Date inactiveTime;
    private int tableHash;
    private long triggerRowHash;
    private TriggerReBuildReason lastTriggerBuildReason;

    public TriggerHistory() {
        this.createTime = new Date();
    }

    public TriggerHistory(String tableName, String pkColumnNames, String columnNames) {
        this.sourceTableName = tableName;
        this.pkColumnNames = pkColumnNames;
        this.columnNames = columnNames;
    }

    public TriggerHistory(Table table, Trigger trigger) {
        this(table, trigger, null);
    }

    public TriggerHistory(Table table, Trigger trigger, TriggerReBuildReason reason) {
        this();
        this.sourceTableName = table.getName();
        this.lastTriggerBuildReason = reason;
        this.columnNames = this.getCommaDeliminatedColumns(trigger.orderColumnsForTable(table));
        this.sourceSchemaName = trigger.getSourceSchemaName();
        this.sourceCatalogName = trigger.getSourceCatalogName();
        this.triggerId = trigger.getTriggerId();
        this.pkColumnNames = this.getCommaDeliminatedColumns(table.getPrimaryKeyColumns());
        this.triggerRowHash = trigger.toHashedValue();
        if (this.pkColumnNames == null) {
            this.pkColumnNames = this.columnNames;
        }
        this.tableHash = TriggerHistory.calculateTableHashFor(table);
    }

    public static int calculateTableHashFor(Table table) {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + table.getName().hashCode();
        result = 31 * result + TriggerHistory.calculateHashForColumns(31, table.getColumns());
        result = 31 * result + TriggerHistory.calculateHashForColumns(31, table.getPrimaryKeyColumns());
        return result;
    }

    private static int calculateHashForColumns(int PRIME, Column[] cols) {
        int result = 1;
        if (cols != null && cols.length > 0) {
            for (Column column : cols) {
                result = PRIME * result + column.getName().hashCode();
                result = PRIME * result + column.getType().hashCode();
                result = PRIME * result + column.getSizeAsInt();
            }
        }
        return result;
    }

    private String getCommaDeliminatedColumns(Column[] cols) {
        StringBuilder columns = new StringBuilder();
        if (cols != null && cols.length > 0) {
            for (Column column : cols) {
                columns.append(column.getName());
                columns.append(",");
            }
            columns.replace(columns.length() - 1, columns.length(), "");
            return columns.toString();
        }
        return null;
    }

    public String getTriggerNameForDmlType(DataEventType type) {
        switch (type) {
            case INSERT: {
                return this.getNameForInsertTrigger();
            }
            case UPDATE: {
                return this.getNameForUpdateTrigger();
            }
            case DELETE: {
                return this.getNameForDeleteTrigger();
            }
        }
        throw new IllegalStateException();
    }

    public String[] getParsedColumnNames() {
        return this.getData("columnNames", this.columnNames);
    }

    public String[] getParsedPkColumnNames() {
        return this.getData("pkColumnNames", this.pkColumnNames);
    }

    public int getTableHash() {
        return this.tableHash;
    }

    public void setTableHash(int tableHash) {
        this.tableHash = tableHash;
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public void setSourceTableName(String tableName) {
        this.sourceTableName = tableName;
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String allColumnData) {
        this.columnNames = allColumnData;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public TriggerReBuildReason getLastTriggerBuildReason() {
        return this.lastTriggerBuildReason;
    }

    public void setLastTriggerBuildReason(TriggerReBuildReason lastTriggerBuildReason) {
        this.lastTriggerBuildReason = lastTriggerBuildReason;
    }

    public String getPkColumnNames() {
        return this.pkColumnNames;
    }

    public void setPkColumnNames(String pkColumnData) {
        this.pkColumnNames = pkColumnData;
    }

    public int getTriggerHistoryId() {
        return this.triggerHistoryId;
    }

    public void setTriggerHistoryId(int tableSyncAuditId) {
        this.triggerHistoryId = tableSyncAuditId;
    }

    public String getNameForDeleteTrigger() {
        return this.nameForDeleteTrigger;
    }

    public void setNameForDeleteTrigger(String nameForDeleteTrigger) {
        this.nameForDeleteTrigger = nameForDeleteTrigger;
    }

    public String getNameForInsertTrigger() {
        return this.nameForInsertTrigger;
    }

    public void setNameForInsertTrigger(String nameForInsertTrigger) {
        this.nameForInsertTrigger = nameForInsertTrigger;
    }

    public String getNameForUpdateTrigger() {
        return this.nameForUpdateTrigger;
    }

    public void setNameForUpdateTrigger(String nameForUpdateTrigger) {
        this.nameForUpdateTrigger = nameForUpdateTrigger;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void setSourceSchemaName(String schemaName) {
        this.sourceSchemaName = schemaName;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public Date getInactiveTime() {
        return this.inactiveTime;
    }

    public void setInactiveTime(Date inactiveTime) {
        this.inactiveTime = inactiveTime;
    }

    public String getSourceCatalogName() {
        return this.sourceCatalogName;
    }

    public void setSourceCatalogName(String sourceCatalogName) {
        this.sourceCatalogName = sourceCatalogName;
    }

    public long getTriggerRowHash() {
        return this.triggerRowHash;
    }

    public void setTriggerRowHash(long triggerRowHash) {
        this.triggerRowHash = triggerRowHash;
    }
}

