/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Router {
    static final Log logger = LogFactory.getLog(Router.class);
    private static final long serialVersionUID = 8947288471097851573L;
    private static int maxRouterId;
    private String routerId = Integer.toString(maxRouterId++);
    private String sourceNodeGroupId;
    private String targetNodeGroupId;
    private String routerType = null;
    private String routerExpression = null;
    private boolean syncOnUpdate = true;
    private boolean syncOnInsert = true;
    private boolean syncOnDelete = true;
    private String targetCatalogName;
    private String targetSchemaName;
    private String targetTableName;
    private Date createTime;
    private Date lastUpdateTime;
    private String lastUpdateBy;

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setCreateTime(Date createdOn) {
        this.createTime = createdOn;
    }

    public void setLastUpdateTime(Date lastModifiedOn) {
        this.lastUpdateTime = lastModifiedOn;
    }

    public void setLastUpdateBy(String updatedBy) {
        this.lastUpdateBy = updatedBy;
    }

    public boolean hasChangedSinceLastTriggerBuild(Date lastTriggerBuildTime) {
        return lastTriggerBuildTime == null || this.getLastUpdateTime() == null || lastTriggerBuildTime.before(this.getLastUpdateTime());
    }

    public String getSourceNodeGroupId() {
        return this.sourceNodeGroupId;
    }

    public void setSourceNodeGroupId(String domainName) {
        this.sourceNodeGroupId = domainName;
    }

    public String getTargetNodeGroupId() {
        return this.targetNodeGroupId;
    }

    public void setTargetNodeGroupId(String targetDomainName) {
        this.targetNodeGroupId = targetDomainName;
    }

    public String getRouterId() {
        return this.routerId;
    }

    public void setRouterId(String routerId) {
        int id;
        this.routerId = routerId;
        if (StringUtils.isNumeric((String)routerId) && (id = Integer.parseInt(routerId)) >= maxRouterId) {
            maxRouterId = id + 1;
        }
    }

    public String getTargetSchemaName() {
        return this.targetSchemaName;
    }

    public void setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    public String getTargetCatalogName() {
        return this.targetCatalogName;
    }

    public void setTargetCatalogName(String targetCatalogName) {
        this.targetCatalogName = targetCatalogName;
    }

    public void setRouterType(String routerName) {
        this.routerType = routerName;
    }

    public String getRouterType() {
        return this.routerType;
    }

    public String getRouterExpression() {
        return this.routerExpression;
    }

    public void setRouterExpression(String routingExpression) {
        this.routerExpression = routingExpression;
    }

    public void setSyncOnDelete(boolean syncOnDelete) {
        this.syncOnDelete = syncOnDelete;
    }

    public boolean isSyncOnDelete() {
        return this.syncOnDelete;
    }

    public void setSyncOnInsert(boolean syncOnInsert) {
        this.syncOnInsert = syncOnInsert;
    }

    public boolean isSyncOnInsert() {
        return this.syncOnInsert;
    }

    public void setSyncOnUpdate(boolean syncOnUpdate) {
        this.syncOnUpdate = syncOnUpdate;
    }

    public boolean isSyncOnUpdate() {
        return this.syncOnUpdate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Router) {
            return this.routerId == ((Router)obj).routerId;
        }
        return false;
    }

    public int hashCode() {
        return this.routerId != null ? this.routerId.hashCode() : super.hashCode();
    }
}

