/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.Date;
import org.jumpmind.symmetric.model.BatchInfo;

public class OutgoingBatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long batchId;
    private String nodeId;
    private String channelId;
    private Status status = Status.RT;
    private long routerMillis;
    private long networkMillis;
    private long filterMillis;
    private long loadMillis;
    private long extractMillis;
    private long byteCount;
    private long sentCount;
    private long dataEventCount;
    private long failedDataId;
    private String sqlState;
    private int sqlCode;
    private String sqlMessage;
    private String lastUpdatedHostName;
    private Date lastUpdatedTime;
    private Date createTime;

    public OutgoingBatch() {
    }

    public OutgoingBatch(String nodeId, String channelId, Status status) {
        this.status = status;
        this.nodeId = nodeId;
        this.channelId = channelId;
        this.createTime = new Date();
    }

    public void resetStats() {
        this.dataEventCount = 0L;
        this.byteCount = 0L;
        this.filterMillis = 0L;
        this.extractMillis = 0L;
        this.loadMillis = 0L;
        this.networkMillis = 0L;
    }

    public void setSentCount(long sentCount) {
        this.sentCount = sentCount;
    }

    public long getSentCount() {
        return this.sentCount;
    }

    public String getNodeBatchId() {
        return this.nodeId + "-" + this.batchId;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String locationId) {
        this.nodeId = locationId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setStatus(String status) {
        this.status = Status.valueOf(status);
    }

    public BatchInfo getBatchInfo() {
        return new BatchInfo(this.batchId);
    }

    public long getRouterMillis() {
        return this.routerMillis;
    }

    public void setRouterMillis(long routerMillis) {
        this.routerMillis = routerMillis;
    }

    public long getNetworkMillis() {
        return this.networkMillis;
    }

    public void setNetworkMillis(long networkMillis) {
        this.networkMillis = networkMillis;
    }

    public long getFilterMillis() {
        return this.filterMillis;
    }

    public void setFilterMillis(long filterMillis) {
        this.filterMillis = filterMillis;
    }

    public long getLoadMillis() {
        return this.loadMillis;
    }

    public void setLoadMillis(long databaseMillis) {
        this.loadMillis = databaseMillis;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public long getDataEventCount() {
        return this.dataEventCount;
    }

    public void setDataEventCount(long dataEventCount) {
        this.dataEventCount = dataEventCount;
    }

    public void setExtractMillis(long extractMillis) {
        this.extractMillis = extractMillis;
    }

    public long getExtractMillis() {
        return this.extractMillis;
    }

    public void incrementDataEventCount() {
        ++this.dataEventCount;
    }

    public void incrementByteCount(int size) {
        this.byteCount += (long)size;
    }

    public long getFailedDataId() {
        return this.failedDataId;
    }

    public void setFailedDataId(long failedDataId) {
        this.failedDataId = failedDataId;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public void setSqlState(String sqlState) {
        this.sqlState = sqlState;
    }

    public int getSqlCode() {
        return this.sqlCode;
    }

    public void setSqlCode(int sqlCode) {
        this.sqlCode = sqlCode;
    }

    public String getSqlMessage() {
        return this.sqlMessage;
    }

    public void setSqlMessage(String sqlMessage) {
        this.sqlMessage = sqlMessage;
    }

    public String getLastUpdatedHostName() {
        return this.lastUpdatedHostName;
    }

    public void setLastUpdatedHostName(String lastUpdatedHostName) {
        this.lastUpdatedHostName = lastUpdatedHostName;
    }

    public Date getLastUpdatedTime() {
        if (this.lastUpdatedTime == null) {
            return new Date();
        }
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        RT,
        NE,
        SE,
        ER,
        OK,
        IG;

    }
}

