/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.sql.Time;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.jumpmind.symmetric.util.AppUtils;

public class NodeGroupChannelWindow {
    private String nodeGroupId;
    private String channelId;
    private Time startTime;
    private Time endTime;
    private boolean enabled;
    final FastDateFormat HHmmss = FastDateFormat.getInstance((String)"HH:mm:ss");

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public void setNodeGroupId(String nodeGroupId) {
        this.nodeGroupId = nodeGroupId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public Time getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Time startTime) {
        this.startTime = startTime;
    }

    public Time getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Time endTime) {
        this.endTime = endTime;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean inTimeWindow(Date date) {
        Time time = Time.valueOf(this.HHmmss.format(date));
        return this.inTimeWindow(time);
    }

    public boolean inTimeWindow(Time time) {
        if (this.enabled) {
            return this.startTime.before(time) && this.endTime.after(time) || this.startTime.before(time) && this.endTime.before(this.startTime) || this.endTime.after(time) && this.startTime.after(this.endTime);
        }
        return true;
    }

    public boolean inTimeWindow(String timezoneOffset) {
        return this.inTimeWindow(AppUtils.getLocalDateForOffset(timezoneOffset));
    }
}

