/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.service.IParameterService;

public class Node {
    private static final long serialVersionUID = 5228552569658130763L;
    private int MAX_VERSION_SIZE = 50;
    private String nodeId;
    private String nodeGroupId;
    private String externalId;
    private String syncUrl;
    private String schemaVersion;
    private String databaseType;
    private String symmetricVersion = Version.version();
    private String databaseVersion;
    private boolean syncEnabled;
    private String timezoneOffset;
    private Date heartbeatTime = new Date();
    private String createdAtNodeId;
    private int batchToSendCount;
    private int batchInErrorCount;

    public Node() {
    }

    public Node(String nodeId, String nodeGroupId) {
        this.nodeId = nodeId;
        this.externalId = nodeId;
        this.nodeGroupId = nodeGroupId;
    }

    public Node(IParameterService runtimeConfig, IDbDialect dbDialect) {
        this.setNodeGroupId(runtimeConfig.getNodeGroupId());
        this.setExternalId(runtimeConfig.getExternalId());
        this.setDatabaseType(dbDialect.getName());
        this.setDatabaseVersion(dbDialect.getVersion());
        this.setSyncUrl(runtimeConfig.getSyncUrl());
        this.setSchemaVersion(runtimeConfig.getString("schema.version"));
    }

    public Node(String nodeId, String syncURL, String version) {
        this.nodeId = nodeId;
        this.syncUrl = syncURL;
        this.schemaVersion = version;
    }

    public boolean equals(Object n) {
        return n != null && n instanceof Node && this.nodeId != null && this.nodeId.equals(((Node)n).getNodeId());
    }

    public int hashCode() {
        return this.nodeId != null ? this.nodeId.hashCode() : super.hashCode();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getSyncUrl() {
        return this.syncUrl;
    }

    public void setSyncUrl(String syncURL) {
        this.syncUrl = syncURL;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String version) {
        this.schemaVersion = StringUtils.abbreviate((String)version, (int)this.MAX_VERSION_SIZE);
    }

    public boolean isSyncEnabled() {
        return this.syncEnabled;
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this.syncEnabled = syncEnabled;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String domainId) {
        this.externalId = domainId;
    }

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public void setNodeGroupId(String domainName) {
        this.nodeGroupId = domainName;
    }

    public String getSymmetricVersion() {
        return this.symmetricVersion;
    }

    public void setSymmetricVersion(String symmetricVersion) {
        this.symmetricVersion = symmetricVersion;
    }

    public String toString() {
        return this.nodeGroupId + ":" + this.externalId + ":" + (this.nodeId == null ? "?" : this.nodeId);
    }

    public Date getHeartbeatTime() {
        return this.heartbeatTime;
    }

    public void setHeartbeatTime(Date heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
    }

    public String getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public void setTimezoneOffset(String timezoneOffset) {
        this.timezoneOffset = timezoneOffset;
    }

    public String getCreatedAtNodeId() {
        return this.createdAtNodeId;
    }

    public void setCreatedAtNodeId(String createdByNodeId) {
        this.createdAtNodeId = createdByNodeId;
    }

    public void setBatchInErrorCount(int batchesInErrorCount) {
        this.batchInErrorCount = batchesInErrorCount;
    }

    public int getBatchInErrorCount() {
        return this.batchInErrorCount;
    }

    public void setBatchToSendCount(int batchesToSendCount) {
        this.batchToSendCount = batchesToSendCount;
    }

    public int getBatchToSendCount() {
        return this.batchToSendCount;
    }

    public boolean isVersionGreaterThanOrEqualTo(int ... targetVersion) {
        if (this.symmetricVersion != null) {
            if (this.symmetricVersion.equals("development")) {
                return true;
            }
            int[] currentVersion = Version.parseVersion(this.symmetricVersion);
            for (int i = 0; i < currentVersion.length; ++i) {
                int j = currentVersion[i];
                if (targetVersion.length <= i) continue;
                if (j > targetVersion[i]) {
                    return true;
                }
                if (j >= targetVersion[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

