/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Collection;
import org.jumpmind.symmetric.model.NodeChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel {
    private static final long serialVersionUID = -8183376200537307264L;
    private String channelId;
    private int processingOrder;
    private int maxBatchSize;
    private int maxBatchToSend;
    private int maxDataToRoute = 10000;
    private boolean enabled;
    private boolean useOldDataToRoute = true;
    private boolean useRowDataToRoute = true;
    private boolean usePkDataToRoute = true;
    private String batchAlgorithm = "default";
    private long extractPeriodMillis = 0L;

    public Channel() {
    }

    public Channel(String id, int processingOrder) {
        this.channelId = id;
        this.processingOrder = processingOrder;
    }

    public Channel(String id, int processingOrder, int maxBatchSize, int maxBatchToSend, boolean enabled, long extractPeriodMillis) {
        this(id, processingOrder);
        this.maxBatchSize = maxBatchSize;
        this.maxBatchToSend = maxBatchToSend;
        this.enabled = enabled;
        this.extractPeriodMillis = extractPeriodMillis;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String id) {
        this.channelId = id;
    }

    public int getProcessingOrder() {
        return this.processingOrder;
    }

    public void setProcessingOrder(int priority) {
        this.processingOrder = priority;
    }

    public void setMaxDataToRoute(int maxDataToRoute) {
        this.maxDataToRoute = maxDataToRoute;
    }

    public int getMaxDataToRoute() {
        return this.maxDataToRoute;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxNumberOfEvents) {
        this.maxBatchSize = maxNumberOfEvents;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMaxBatchToSend() {
        return this.maxBatchToSend;
    }

    public void setMaxBatchToSend(int maxBatchToSend) {
        this.maxBatchToSend = maxBatchToSend;
    }

    public boolean isInList(Collection<? extends NodeChannel> channels) {
        if (channels != null) {
            for (NodeChannel nodeChannel : channels) {
                if (!nodeChannel.getChannelId().equals(this.channelId)) continue;
                return true;
            }
        }
        return false;
    }

    public void setBatchAlgorithm(String batchAlgorithm) {
        this.batchAlgorithm = batchAlgorithm;
    }

    public String getBatchAlgorithm() {
        return this.batchAlgorithm;
    }

    public long getExtractPeriodMillis() {
        return this.extractPeriodMillis;
    }

    public void setExtractPeriodMillis(long extractPeriodMillis) {
        this.extractPeriodMillis = extractPeriodMillis;
    }

    public void setUseOldDataToRoute(boolean useOldDataToRoute) {
        this.useOldDataToRoute = useOldDataToRoute;
    }

    public boolean isUseOldDataToRoute() {
        return this.useOldDataToRoute;
    }

    public void setUseRowDataToRoute(boolean useRowDataToRoute) {
        this.useRowDataToRoute = useRowDataToRoute;
    }

    public boolean isUseRowDataToRoute() {
        return this.useRowDataToRoute;
    }

    public void setUsePkDataToRoute(boolean usePkDataToRoute) {
        this.usePkDataToRoute = usePkDataToRoute;
    }

    public boolean isUsePkDataToRoute() {
        return this.usePkDataToRoute;
    }
}

