/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.map;

import java.util.Map;
import java.util.TreeMap;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.ITableColumnFilter;
import org.jumpmind.symmetric.load.StatementBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeColumnsNamesFilter
implements ITableColumnFilter,
INodeGroupExtensionPoint {
    private String[] tables;
    private Map<String, String> columnNameMapping;
    private boolean autoRegister = true;
    private String[] nodeGroupIdsToApplyTo;

    @Override
    public String[] getTables() {
        return this.tables;
    }

    public void setTables(String[] tables) {
        this.tables = tables;
    }

    @Override
    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    @Override
    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdsToApplyTo(String[] nodeGroupIdsToApplyTo) {
        this.nodeGroupIdsToApplyTo = nodeGroupIdsToApplyTo;
    }

    public Map<String, String> getColumnNameMapping() {
        return this.columnNameMapping;
    }

    public void setColumnNameMapping(Map<String, String> columns) {
        this.columnNameMapping = new TreeMap<String, String>(columns);
    }

    @Override
    public String[] filterColumnsNames(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, String[] columnNames) {
        if (this.columnNameMapping != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                String newColumnName = this.columnNameMapping.get(columnNames[i]);
                if (newColumnName == null) continue;
                columnNames[i] = newColumnName;
            }
        }
        return columnNames;
    }

    @Override
    public Object[] filterColumnsValues(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, Object[] columnValues) {
        return columnValues;
    }
}

