/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.map;

import java.util.Map;
import java.util.TreeMap;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.ITableColumnFilter;
import org.jumpmind.symmetric.load.StatementBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddColumnsFilter
implements ITableColumnFilter,
INodeGroupExtensionPoint {
    private String[] tables;
    private Map<String, Object> additionalColumns;
    private boolean autoRegister = true;
    private String[] nodeGroupIdsToApplyTo;

    @Override
    public String[] getTables() {
        return this.tables;
    }

    public void setTables(String[] tables) {
        this.tables = tables;
    }

    @Override
    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    @Override
    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdsToApplyTo(String[] nodeGroupIdsToApplyTo) {
        this.nodeGroupIdsToApplyTo = nodeGroupIdsToApplyTo;
    }

    public Map<String, Object> getAdditionalColumns() {
        return this.additionalColumns;
    }

    public void setAdditionalColumns(Map<String, Object> columns) {
        this.additionalColumns = new TreeMap<String, Object>(columns);
    }

    @Override
    public String[] filterColumnsNames(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, String[] columnNames) {
        if (this.additionalColumns != null) {
            int i;
            String[] columnNamesPlus = new String[columnNames.length + this.additionalColumns.size()];
            for (i = 0; i < columnNames.length; ++i) {
                columnNamesPlus[i] = columnNames[i];
            }
            i = columnNames.length;
            for (String extraCol : this.additionalColumns.keySet()) {
                columnNamesPlus[i++] = extraCol;
            }
            return columnNamesPlus;
        }
        return columnNames;
    }

    @Override
    public Object[] filterColumnsValues(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, Object[] columnValues) {
        if (this.additionalColumns != null) {
            int i;
            Object[] columnValuesPlus = new Object[columnValues.length + this.additionalColumns.size()];
            for (i = 0; i < columnValues.length; ++i) {
                columnValuesPlus[i] = columnValues[i];
            }
            i = columnValues.length;
            for (String extraCol : this.additionalColumns.keySet()) {
                Object extraValue = this.additionalColumns.get(extraCol);
                if (":EXTERNAL_ID".equals(extraValue)) {
                    extraValue = ctx.getNode() != null ? ctx.getNode().getExternalId() : null;
                } else if (":NODE_ID".equals(extraValue)) {
                    extraValue = ctx.getNodeId();
                } else if (":NODE_GROUP_ID".equals(extraValue)) {
                    extraValue = ctx.getNode() != null ? ctx.getNode().getNodeGroupId() : null;
                }
                columnValuesPlus[i++] = extraValue;
            }
            return columnValuesPlus;
        }
        return columnValues;
    }
}

