/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load.csv;

import bsh.EvalError;
import bsh.Interpreter;
import com.csvreader.CsvReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.load.DataLoaderContext;
import org.jumpmind.symmetric.load.DataLoaderStatistics;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.IDataLoader;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.load.IDataLoaderStatistics;
import org.jumpmind.symmetric.load.TableTemplate;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.util.CsvUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvLoader
implements IDataLoader {
    static final ILog log = LogFactory.getLog(CsvLoader.class);
    protected JdbcTemplate jdbcTemplate;
    protected IDbDialect dbDialect;
    protected IParameterService parameterService;
    protected ITriggerRouterService triggerRouterService;
    protected INodeService nodeService;
    protected CsvReader csvReader;
    protected DataLoaderContext context;
    protected DataLoaderStatistics stats;
    protected List<IDataLoaderFilter> filters;
    protected Map<String, List<IColumnFilter>> columnFilters;

    @Override
    public void open(BufferedReader reader) throws IOException {
        this.csvReader = CsvUtils.getCsvReader(reader);
        this.context = new DataLoaderContext(this.nodeService);
        this.stats = new DataLoaderStatistics();
    }

    @Override
    public void open(BufferedReader reader, List<IDataLoaderFilter> filters, Map<String, List<IColumnFilter>> columnFilters) throws IOException {
        this.open(reader);
        this.filters = filters;
        this.columnFilters = columnFilters;
    }

    @Override
    public boolean hasNext() throws IOException {
        while (this.csvReader.readRecord()) {
            String[] tokens = this.csvReader.getValues();
            if (tokens[0].equals("batch")) {
                this.context.setBatchId(new Long(tokens[1]));
                this.stats = new DataLoaderStatistics();
                return true;
            }
            if (tokens[0].equals("nodeid")) {
                this.context.setNodeId(tokens[1]);
                continue;
            }
            if (this.isMetaTokenParsed(tokens)) continue;
            throw new RuntimeException("Unexpected token '" + tokens[0] + "' while parsing for next batch");
        }
        return false;
    }

    @Override
    public void skip() throws IOException {
        this.context.setSkipping(true);
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean load() throws IOException {
        boolean bl;
        try {
            long rowsBeforeCommit = this.parameterService.getLong("dataloader.max.rows.before.commit");
            long rowsProcessed = 0L;
            this.prepareTableForDataLoad();
            while (this.csvReader.readRecord()) {
                Object[] tokens = this.csvReader.getValues();
                this.stats.incrementLineCount();
                if (tokens != null && tokens.length > 0 && tokens[0] != null) {
                    this.stats.incrementByteCount(this.csvReader.getRawRecord().length());
                    if (tokens[0].equals("insert")) {
                        if (this.context.getTableTemplate() == null) {
                            throw new IllegalStateException("The table metadata was missing from the protocol.  Please turn on debug level logging to analyze the CSV data.");
                        }
                        if (!this.context.getTableTemplate().isIgnoreThisTable() && !this.context.isSkipping()) {
                            this.insert((String[])tokens);
                            ++rowsProcessed;
                        }
                    } else if (tokens[0].equals("update")) {
                        if (this.context.getTableTemplate() == null) {
                            throw new IllegalStateException("The table metadata was missing from the protocol.  Please turn on debug level logging to analyze the CSV data.");
                        }
                        if (!this.context.getTableTemplate().isIgnoreThisTable() && !this.context.isSkipping()) {
                            this.update((String[])tokens);
                            ++rowsProcessed;
                        }
                    } else if (tokens[0].equals("delete")) {
                        if (this.context.getTableTemplate() == null) {
                            throw new IllegalStateException("The table metadata was missing from the protocol.  Please turn on debug level logging to analyze the CSV data.");
                        }
                        if (!this.context.getTableTemplate().isIgnoreThisTable() && !this.context.isSkipping()) {
                            this.delete((String[])tokens);
                            ++rowsProcessed;
                        }
                    } else if (tokens[0].equals("old")) {
                        this.context.setOldData((String[])ArrayUtils.subarray((Object[])tokens, (int)1, (int)tokens.length));
                    } else {
                        if (this.isMetaTokenParsed((String[])tokens)) continue;
                        if (((String)tokens[0]).equals("commit")) {
                            rowsProcessed = 0L;
                            break;
                        }
                        if (((String)tokens[0]).equals("sql")) {
                            if (!(this.context.getTableTemplate() != null && this.context.getTableTemplate().isIgnoreThisTable() || this.context.isSkipping())) {
                                this.runSql((String)tokens[1]);
                                ++rowsProcessed;
                            }
                        } else if (((String)tokens[0]).equals("bsh")) {
                            if (!this.context.isSkipping()) {
                                this.runBsh((String)tokens[1]);
                                ++rowsProcessed;
                            }
                        } else if (((String)tokens[0]).equals("create")) {
                            if (!this.context.isSkipping()) {
                                this.runDdl((String)tokens[1]);
                                ++rowsProcessed;
                            }
                        } else {
                            log.warn("LoaderTokenUnexpected", tokens[0], this.stats.getLineCount(), this.context.getBatchId());
                        }
                    }
                }
                if (rowsProcessed <= rowsBeforeCommit || rowsBeforeCommit <= 0L) continue;
                boolean bl2 = false;
                Object var8_6 = null;
                this.cleanupAfterDataLoad();
                return bl2;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cleanupAfterDataLoad();
            throw throwable;
        }
        Object var8_7 = null;
        this.cleanupAfterDataLoad();
        return bl;
    }

    protected void runBsh(String script) {
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.eval(script);
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isMetaTokenParsed(String[] tokens) {
        boolean isMetaTokenParsed = true;
        if (tokens[0].equals("schema")) {
            this.context.setSchemaName(StringUtils.isBlank((String)tokens[1]) ? null : tokens[1]);
        } else if (tokens[0].equals("catalog")) {
            this.context.setCatalogName(StringUtils.isBlank((String)tokens[1]) ? null : tokens[1]);
        } else if (tokens[0].equals("table")) {
            this.resetTable(tokens[1]);
        } else if (tokens[0].equals("keys")) {
            this.context.setKeyNames((String[])ArrayUtils.subarray((Object[])tokens, (int)1, (int)tokens.length));
        } else if (tokens[0].equals("columns")) {
            this.context.setColumnNames((String[])ArrayUtils.subarray((Object[])tokens, (int)1, (int)tokens.length));
        } else if (tokens[0].equals("binary")) {
            this.context.setBinaryEncodingType(tokens[1]);
        } else if (tokens[0].equals("channel")) {
            this.context.setChannelId(tokens[1]);
        } else {
            isMetaTokenParsed = false;
        }
        return isMetaTokenParsed;
    }

    protected void resetTable(String tableName) {
        this.cleanupAfterDataLoad();
        this.context.setTableName(tableName);
        if (this.context.getTableTemplate() == null) {
            this.context.setTableTemplate(new TableTemplate(this.jdbcTemplate, this.dbDialect, tableName, this.columnFilters != null ? this.columnFilters.get(tableName) : null, this.parameterService.is("dont.include.keys.in.update.statement"), this.context.getSchemaName(), this.context.getCatalogName()));
        }
        this.prepareTableForDataLoad();
    }

    protected void prepareTableForDataLoad() {
        if (this.context != null && this.context.getTableTemplate() != null) {
            this.dbDialect.prepareTableForDataLoad(this.context.getTableTemplate().getTable());
        }
    }

    protected void cleanupAfterDataLoad() {
        if (this.context != null && this.context.getTableTemplate() != null) {
            this.dbDialect.cleanupAfterDataLoad(this.context.getTableTemplate().getTable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insert(String[] tokens) {
        this.stats.incrementStatementCount();
        String[] columnValues = this.parseColumns(tokens, 1);
        int rows = 0;
        boolean continueToLoad = true;
        if (this.filters != null) {
            this.stats.startTimer();
            for (IDataLoaderFilter filter : this.filters) {
                continueToLoad &= filter.filterInsert(this.context, columnValues);
            }
            this.stats.incrementFilterMillis(this.stats.endTimer());
        }
        if (continueToLoad) {
            boolean enableFallbackUpdate = this.parameterService.is("dataloader.enable.fallback.update");
            Object savepoint = null;
            try {
                try {
                    this.stats.startTimer();
                    if (enableFallbackUpdate) {
                        savepoint = this.dbDialect.createSavepointForFallback();
                    }
                    rows = this.context.getTableTemplate().insert(this.context, columnValues);
                    this.dbDialect.releaseSavepoint(savepoint);
                }
                catch (DataIntegrityViolationException e) {
                    if (enableFallbackUpdate) {
                        this.dbDialect.rollbackToSavepoint(savepoint);
                        if (log.isDebugEnabled()) {
                            log.debug("LoaderInsertingFailedUpdating", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                        }
                        String[] keyValues = this.parseKeys(tokens, 1);
                        this.stats.incrementFallbackUpdateCount();
                        rows = this.context.getTableTemplate().update(this.context, columnValues, keyValues);
                        if (rows == 0) {
                            throw new SymmetricException("LoaderFallbackUpdateFailed", (Throwable)e, this.context.getTableName(), ArrayUtils.toString((Object)tokens), ArrayUtils.toString((Object)keyValues));
                        }
                    } else {
                        log.error("LoaderInsertingFailed", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                        throw e;
                    }
                    Object var10_9 = null;
                    this.stats.incrementDatabaseMillis(this.stats.endTimer());
                }
                Object var10_8 = null;
                this.stats.incrementDatabaseMillis(this.stats.endTimer());
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.stats.incrementDatabaseMillis(this.stats.endTimer());
                throw throwable;
            }
        }
        return rows;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int update(String[] tokens) {
        this.stats.incrementStatementCount();
        String[] columnValues = this.parseColumns(tokens, 1);
        String[] keyValues = this.parseKeys(tokens, 1 + columnValues.length);
        int rows = 0;
        boolean continueToLoad = true;
        if (this.filters != null) {
            this.stats.startTimer();
            for (IDataLoaderFilter filter : this.filters) {
                continueToLoad &= filter.filterUpdate(this.context, columnValues, keyValues);
            }
            this.stats.incrementFilterMillis(this.stats.endTimer());
        }
        if (continueToLoad) {
            boolean enableFallbackInsert = this.parameterService.is("dataloader.enable.fallback.insert");
            this.stats.startTimer();
            rows = this.context.getTableTemplate().update(this.context, columnValues, keyValues);
            if (rows == 0) {
                if (!enableFallbackInsert) {
                    this.stats.incrementDatabaseMillis(this.stats.endTimer());
                    throw new SymmetricException("LoaderUpdatingFailed", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                }
                log.debug("LoaderUpdatingFailedInserting", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                this.stats.incrementFallbackInsertCount();
                rows = this.context.getTableTemplate().insert(this.context, columnValues);
            } else if (rows > 1) {
                log.warn("LoaderRowsUpdatingFailed", rows, this.context.getTableName(), ArrayUtils.toString((Object)tokens));
            }
            this.stats.incrementDatabaseMillis(this.stats.endTimer());
        }
        return rows;
    }

    protected int delete(String[] tokens) {
        this.stats.incrementStatementCount();
        String[] keyValues = this.parseKeys(tokens, 1);
        int rows = 0;
        boolean continueToLoad = true;
        if (this.filters != null) {
            this.stats.startTimer();
            for (IDataLoaderFilter filter : this.filters) {
                continueToLoad &= filter.filterDelete(this.context, keyValues);
            }
            this.stats.incrementFilterMillis(this.stats.endTimer());
        }
        if (continueToLoad) {
            boolean allowMissingDelete = this.parameterService.is("dataloader.allow.missing.delete");
            this.stats.startTimer();
            rows = this.context.getTableTemplate().delete(this.context, keyValues);
            this.stats.incrementDatabaseMillis(this.stats.endTimer());
            if (rows == 0) {
                if (allowMissingDelete) {
                    log.warn("LoaderDeleteMissing", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                    this.stats.incrementMissingDeleteCount();
                } else {
                    throw new SymmetricException("LoaderDeleteMissing", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                }
            }
        }
        return rows;
    }

    protected void runSql(String sql) {
        this.stats.incrementStatementCount();
        log.debug("ScriptRunning", sql);
        this.jdbcTemplate.execute(sql);
        if (this.context.getTableTemplate() != null) {
            this.context.getTableTemplate().resetMetaData(false);
        }
    }

    protected void runDdl(String xml) {
        this.stats.incrementStatementCount();
        log.debug("DDLRunning", xml);
        this.dbDialect.createTables(xml);
        if (this.context.getTableTemplate() != null) {
            this.context.getTableTemplate().resetMetaData(false);
        }
    }

    protected String[] parseKeys(String[] tokens, int startIndex) {
        if (this.context.getTableTemplate().getKeyNames() == null) {
            throw new RuntimeException("Key names were not specified for table " + this.context.getTableTemplate().getTableName());
        }
        int keyLength = this.context.getTableTemplate().getKeyNames().length;
        return this.parseValues("key", tokens, startIndex, startIndex + keyLength);
    }

    protected String[] parseColumns(String[] tokens, int startIndex) {
        if (this.context.getTableTemplate().getColumnNames() == null) {
            throw new RuntimeException("Column names were not specified for table " + this.context.getTableTemplate().getTableName());
        }
        int columnLength = this.context.getTableTemplate().getColumnNames().length;
        return this.parseValues("column", tokens, startIndex, startIndex + columnLength);
    }

    protected String[] parseValues(String name, String[] tokens, int startIndex, int endIndex) {
        if (tokens.length < endIndex) {
            throw new RuntimeException("Expected to have " + (endIndex - startIndex) + " " + name + " values for " + this.context.getTableTemplate().getTableName() + ": " + ArrayUtils.toString((Object)tokens));
        }
        return (String[])ArrayUtils.subarray((Object[])tokens, (int)startIndex, (int)endIndex);
    }

    @Override
    public IDataLoader clone() {
        CsvLoader dataLoader = new CsvLoader();
        dataLoader.setJdbcTemplate(this.jdbcTemplate);
        dataLoader.setDbDialect(this.dbDialect);
        dataLoader.setParameterService(this.parameterService);
        dataLoader.setTriggerRouterService(this.triggerRouterService);
        dataLoader.setNodeService(this.nodeService);
        return dataLoader;
    }

    @Override
    public void close() {
        if (this.csvReader != null) {
            this.csvReader.close();
        }
    }

    @Override
    public IDataLoaderContext getContext() {
        return this.context;
    }

    @Override
    public IDataLoaderStatistics getStatistics() {
        return this.stats;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerService) {
        this.triggerRouterService = triggerService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }
}

