/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.StatementBuilder;
import org.jumpmind.symmetric.util.ArgTypePreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableTemplate {
    private JdbcTemplate jdbcTemplate;
    private IDbDialect dbDialect;
    private Table table;
    private String schema;
    private String catalog;
    private String tableName;
    private String[] keyNames;
    private String[] columnNames;
    private String[] oldData;
    private Map<String, Column> allMetaData;
    private Column[] keyMetaData;
    private Column[] columnMetaData;
    private Column[] columnKeyMetaData;
    private Column[] noKeyColumnPlusKeyMetaData;
    private HashMap<StatementBuilder.DmlType, StatementBuilder> statementMap;
    private int[] keyIndexesToRemoveOnUpdate;
    private List<IColumnFilter> columnFilters = new ArrayList<IColumnFilter>();
    private boolean dontIncludeKeysInUpdateStatement = false;

    public TableTemplate(JdbcTemplate jdbcTemplate, IDbDialect dbDialect, String tableName, List<IColumnFilter> columnFilters, boolean dontIncludeKeysInUpdateStatement) {
        this(jdbcTemplate, dbDialect, tableName, columnFilters, dontIncludeKeysInUpdateStatement, null, null);
    }

    public TableTemplate(JdbcTemplate jdbcTemplate, IDbDialect dbDialect, String tableName, List<IColumnFilter> columnFilters, boolean dontIncludeKeysInUpdateStatement, String schema, String catalog) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbDialect = dbDialect;
        this.tableName = tableName;
        this.schema = StringUtils.isBlank((String)schema) ? dbDialect.getDefaultSchema() : schema;
        this.catalog = StringUtils.isBlank((String)catalog) ? null : catalog;
        this.setupColumnFilters(columnFilters, dbDialect);
        this.dontIncludeKeysInUpdateStatement = dontIncludeKeysInUpdateStatement;
        this.resetMetaData(true);
    }

    public void resetMetaData(boolean useCache) {
        this.table = this.dbDialect.getTable(this.catalog, this.schema, this.tableName, useCache);
        this.allMetaData = new HashMap<String, Column>();
        this.statementMap = new HashMap();
        this.keyMetaData = null;
        this.columnMetaData = null;
        this.columnKeyMetaData = null;
        if (this.table != null) {
            for (Column column : this.table.getColumns()) {
                this.allMetaData.put(column.getName().trim().toUpperCase(), column);
            }
        }
    }

    private void setupColumnFilters(List<IColumnFilter> pluginFilters, IDbDialect dbDialect) {
        if (pluginFilters != null) {
            for (IColumnFilter columnFilter : pluginFilters) {
                this.columnFilters.add(columnFilter);
            }
        }
        if (dbDialect.getDatabaseColumnFilter() != null) {
            this.columnFilters.add(dbDialect.getDatabaseColumnFilter());
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isIgnoreThisTable() {
        return this.table == null;
    }

    public int insert(IDataLoaderContext ctx, String[] columnValues) {
        StatementBuilder st = this.getStatementBuilder(ctx, StatementBuilder.DmlType.INSERT);
        return this.execute(ctx, st, columnValues, this.columnMetaData);
    }

    public int update(IDataLoaderContext ctx, String[] columnValues, String[] keyValues) {
        String[] values;
        StatementBuilder st = null;
        Column[] metaData = null;
        if (this.oldData != null) {
            ArrayList<String> changedColumnNameList = new ArrayList<String>();
            ArrayList<String> changedColumnValueList = new ArrayList<String>();
            ArrayList<Column> changedColumnMetaList = new ArrayList<Column>();
            for (int i = 0; i < columnValues.length; ++i) {
                Column column;
                if (StringUtils.equals((String)columnValues[i], (String)this.oldData[i]) || (column = this.allMetaData.get(this.columnNames[i].trim().toUpperCase())) == null) continue;
                changedColumnNameList.add(this.columnNames[i]);
                changedColumnMetaList.add(column);
                changedColumnValueList.add(columnValues[i]);
            }
            if (changedColumnNameList.size() <= 0) {
                return 1;
            }
            String[] changedColumnNames = changedColumnNameList.toArray(new String[0]);
            st = this.createStatementBuilder(ctx, StatementBuilder.DmlType.UPDATE, changedColumnNames);
            columnValues = changedColumnValueList.toArray(new String[0]);
            Object[] changedColumnMetaData = changedColumnMetaList.toArray(new Column[0]);
            metaData = (Column[])ArrayUtils.addAll((Object[])changedColumnMetaData, (Object[])this.keyMetaData);
            this.oldData = null;
        } else if (this.dontIncludeKeysInUpdateStatement && (values = this.removeKeysFromColumnValuesIfSame(ctx, keyValues, columnValues)) != null) {
            columnValues = values;
            st = this.getStatementBuilder(ctx, StatementBuilder.DmlType.UPDATE_NO_KEYS);
            metaData = this.noKeyColumnPlusKeyMetaData;
        }
        if (st == null) {
            st = this.getStatementBuilder(ctx, StatementBuilder.DmlType.UPDATE);
            metaData = this.columnKeyMetaData;
        }
        values = (String[])ArrayUtils.addAll((Object[])columnValues, (Object[])keyValues);
        return this.execute(ctx, st, values, metaData);
    }

    private String[] removeKeysFromColumnValuesIfSame(IDataLoaderContext ctx, String[] keyValues, String[] columnValues) {
        if (this.keyIndexesToRemoveOnUpdate == null) {
            Object[] keyNames;
            String[] colNames = ctx.getColumnNames();
            Object[] noKeyColNames = new String[colNames.length - (keyNames = ctx.getKeyNames()).length];
            if (noKeyColNames.length > 0) {
                this.keyIndexesToRemoveOnUpdate = new int[keyNames.length];
                int indexToRemoveIndex = 0;
                int indexOfNoKeyColNames = 0;
                for (int index = 0; index < colNames.length; ++index) {
                    if (ArrayUtils.contains((Object[])keyNames, (Object)colNames[index])) {
                        this.keyIndexesToRemoveOnUpdate[indexToRemoveIndex++] = index;
                        continue;
                    }
                    noKeyColNames[indexOfNoKeyColNames++] = colNames[index];
                }
            } else {
                this.keyIndexesToRemoveOnUpdate = new int[0];
            }
            this.noKeyColumnPlusKeyMetaData = this.getColumnMetaData((String[])ArrayUtils.addAll((Object[])noKeyColNames, (Object[])keyNames));
        }
        if (this.keyIndexesToRemoveOnUpdate.length > 0) {
            if (this.noKeyColumnPlusKeyMetaData == null) {
                String[] noKeys = new String[columnValues.length - keyValues.length];
                int noKeysIndex = 0;
                for (int index = 0; index < columnValues.length; ++index) {
                    if (ArrayUtils.contains((int[])this.keyIndexesToRemoveOnUpdate, (int)index)) continue;
                    noKeys[noKeysIndex++] = columnValues[index];
                }
                return noKeys;
            }
            boolean keyChanged = false;
            for (int index = 0; index < this.keyIndexesToRemoveOnUpdate.length; ++index) {
                if (StringUtils.equals((String)keyValues[index], (String)columnValues[index])) continue;
                keyChanged = true;
            }
            if (!keyChanged) {
                String[] noKeys = new String[columnValues.length - keyValues.length];
                int noKeysIndex = 0;
                for (int index = 0; index < columnValues.length; ++index) {
                    if (ArrayUtils.contains((int[])this.keyIndexesToRemoveOnUpdate, (int)index)) continue;
                    noKeys[noKeysIndex++] = columnValues[index];
                }
                return noKeys;
            }
        }
        return null;
    }

    public int delete(IDataLoaderContext ctx, String[] keyValues) {
        StatementBuilder st = this.getStatementBuilder(ctx, StatementBuilder.DmlType.DELETE);
        return this.execute(ctx, st, keyValues, this.keyMetaData);
    }

    private StatementBuilder getStatementBuilder(IDataLoaderContext ctx, StatementBuilder.DmlType type) {
        StatementBuilder st = this.statementMap.get((Object)type);
        if (st == null) {
            st = this.createStatementBuilder(ctx, type, this.columnNames);
            this.statementMap.put(type, st);
        }
        return st;
    }

    private StatementBuilder createStatementBuilder(IDataLoaderContext ctx, StatementBuilder.DmlType type, String[] filteredColumnNames) {
        if (this.columnFilters != null) {
            for (IColumnFilter columnFilter : this.columnFilters) {
                filteredColumnNames = columnFilter.filterColumnsNames(ctx, type, this.getTable(), filteredColumnNames);
            }
        }
        if (this.keyMetaData == null) {
            this.keyMetaData = this.getColumnMetaData(this.keyNames);
        }
        if (this.columnMetaData == null) {
            this.columnMetaData = this.getColumnMetaData(this.columnNames);
        }
        if (this.columnKeyMetaData == null) {
            this.columnKeyMetaData = (Column[])ArrayUtils.addAll((Object[])this.columnMetaData, (Object[])this.keyMetaData);
        }
        String tableName = this.table.getName();
        if (!StringUtils.isBlank((String)this.schema)) {
            tableName = this.schema + "." + tableName;
        }
        if (!StringUtils.isBlank((String)this.catalog)) {
            tableName = this.catalog + "." + tableName;
        }
        return new StatementBuilder(type, tableName, this.keyMetaData, this.getColumnMetaData(filteredColumnNames), this.dbDialect.isDateOverrideToTimestamp(), this.dbDialect.getIdentifierQuoteString());
    }

    public Object[] getObjectValues(IDataLoaderContext ctx, String[] values) {
        return this.dbDialect.getObjectValues(ctx.getBinaryEncoding(), values, this.columnMetaData == null ? this.getColumnMetaData(this.columnNames) : this.columnMetaData);
    }

    public Object[] getObjectKeyValues(IDataLoaderContext ctx, String[] values) {
        return this.dbDialect.getObjectValues(ctx.getBinaryEncoding(), values, this.keyMetaData == null ? this.getColumnMetaData(this.keyNames) : this.keyMetaData);
    }

    private int execute(IDataLoaderContext ctx, StatementBuilder st, String[] values, Column[] metaData) {
        Object[] objectValues = this.dbDialect.getObjectValues(ctx.getBinaryEncoding(), values, metaData);
        if (this.columnFilters != null) {
            for (IColumnFilter columnFilter : this.columnFilters) {
                objectValues = columnFilter.filterColumnsValues(ctx, st.getDmlType(), this.getTable(), objectValues);
            }
        }
        return this.jdbcTemplate.update(st.getSql(), (PreparedStatementSetter)new ArgTypePreparedStatementSetter(objectValues, st.getTypes(), this.dbDialect.getLobHandler()));
    }

    public void setKeyNames(String[] keyNames) {
        this.keyNames = keyNames;
        this.clear();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.clear();
    }

    public void setOldData(String[] oldData) {
        this.oldData = oldData;
    }

    private void clear() {
        this.statementMap.clear();
        this.keyMetaData = null;
        this.columnMetaData = null;
        this.columnKeyMetaData = null;
        this.oldData = null;
    }

    private Column[] getColumnMetaData(String[] names) {
        Column[] columns = new Column[names.length];
        for (int i = 0; i < names.length; ++i) {
            columns[i] = this.allMetaData.get(names[i].trim().toUpperCase());
        }
        return columns;
    }

    public String[] getKeyNames() {
        return this.keyNames;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Table getTable() {
        return this.table;
    }

    public String[] getOldData() {
        return this.oldData;
    }
}

