/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.ddlutils.model.Column;

public class StatementBuilder {
    protected DmlType dmlType;
    protected String sql;
    protected int[] types;
    protected String quote;

    public StatementBuilder(DmlType type, String tableName, Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp, String identifierQuoteString) {
        String string = this.quote = identifierQuoteString == null ? "" : identifierQuoteString;
        if (type == DmlType.INSERT) {
            this.sql = this.buildInsertSql(tableName, columns);
            this.types = this.buildTypes(columns, isDateOverrideToTimestamp);
        } else if (type == DmlType.UPDATE) {
            this.sql = this.buildUpdateSql(tableName, keys, columns);
            this.types = this.buildTypes(keys, columns, isDateOverrideToTimestamp);
        } else if (type == DmlType.UPDATE_NO_KEYS) {
            columns = this.removeKeysFromColumns(keys, columns);
            this.sql = this.buildUpdateSql(tableName, keys, columns);
            this.types = this.buildTypes(keys, columns, isDateOverrideToTimestamp);
        } else if (type == DmlType.DELETE) {
            this.sql = this.buildDeleteSql(tableName, keys);
            this.types = this.buildTypes(keys, isDateOverrideToTimestamp);
        } else {
            throw new NotImplementedException("Unimplemented SQL type: " + (Object)((Object)type));
        }
        this.dmlType = type;
    }

    protected Column[] removeKeysFromColumns(Column[] keys, Column[] columns) {
        Column[] columnsWithoutKeys = new Column[columns.length - keys.length];
        HashSet keySet = new HashSet();
        CollectionUtils.addAll(keySet, (Object[])keys);
        int n = 0;
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (keySet.contains(column)) continue;
            columnsWithoutKeys[n++] = column;
        }
        return columnsWithoutKeys;
    }

    protected int[] buildTypes(Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp) {
        int[] columnTypes = this.buildTypes(columns, isDateOverrideToTimestamp);
        int[] keyTypes = this.buildTypes(keys, isDateOverrideToTimestamp);
        return ArrayUtils.addAll((int[])columnTypes, (int[])keyTypes);
    }

    protected int[] buildTypes(Column[] columns, boolean isDateOverrideToTimestamp) {
        ArrayList<Integer> list = new ArrayList<Integer>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            list.add(columns[i].getTypeCode());
        }
        int[] types = new int[list.size()];
        int index = 0;
        for (Integer type : list) {
            if (type == 91 && isDateOverrideToTimestamp) {
                type = 93;
            } else if (type == 6 || type == 8) {
                type = 3;
            }
            types[index++] = type;
        }
        return types;
    }

    public String buildInsertSql(String tableName, String[] columnNames) {
        StringBuilder sql = new StringBuilder("insert into " + tableName + "(");
        this.appendColumns(sql, columnNames);
        sql.append(") values (");
        this.appendColumnQuestions(sql, columnNames.length);
        sql.append(")");
        return sql.toString();
    }

    public String buildInsertSql(String tableName, Column[] columns) {
        StringBuilder sql = new StringBuilder("insert into " + tableName + "(");
        int columnCount = this.appendColumns(sql, columns);
        sql.append(") values (");
        this.appendColumnQuestions(sql, columnCount);
        sql.append(")");
        return sql.toString();
    }

    public String buildUpdateSql(String tableName, String[] keyNames, String[] columnNames) {
        StringBuilder sql = new StringBuilder("update ").append(tableName).append(" set ");
        this.appendColumnEquals(sql, columnNames, ", ");
        sql.append(" where ");
        this.appendColumnEquals(sql, keyNames, " and ");
        return sql.toString();
    }

    public String buildUpdateSql(String tableName, Column[] keyColumns, Column[] columns) {
        StringBuilder sql = new StringBuilder("update ").append(tableName).append(" set ");
        this.appendColumnEquals(sql, columns, ", ");
        sql.append(" where ");
        this.appendColumnEquals(sql, keyColumns, " and ");
        return sql.toString();
    }

    public String buildDeleteSql(String tableName, String[] keyNames) {
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where ");
        this.appendColumnEquals(sql, keyNames, " and ");
        return sql.toString();
    }

    public String buildDeleteSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where ");
        this.appendColumnEquals(sql, keyColumns, " and ");
        return sql.toString();
    }

    public void appendColumnEquals(StringBuilder sql, String[] names, String separator) {
        for (int i = 0; i < names.length; ++i) {
            sql.append(this.quote).append(names[i]).append(this.quote).append(" = ?").append(i + 1 < names.length ? separator : "");
        }
    }

    public void appendColumnEquals(StringBuilder sql, Column[] columns, String separator) {
        int existingCount = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            if (existingCount++ > 0) {
                sql.append(separator);
            }
            sql.append(this.quote).append(columns[i].getName()).append(this.quote).append(" = ?");
        }
    }

    public void appendColumns(StringBuilder sql, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            sql.append(this.quote).append(names[i]).append(this.quote).append(i + 1 < names.length ? "," : "");
        }
    }

    public int appendColumns(StringBuilder sql, Column[] columns) {
        int existingCount = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            if (existingCount++ > 0) {
                sql.append(",");
            }
            sql.append(this.quote).append(columns[i].getName()).append(this.quote);
        }
        return existingCount;
    }

    public void appendColumnQuestions(StringBuilder sql, int number) {
        for (int i = 0; i < number; ++i) {
            sql.append("?").append(i + 1 < number ? "," : "");
        }
    }

    public String getSql() {
        return this.sql;
    }

    public DmlType getDmlType() {
        return this.dmlType;
    }

    public int[] getTypes() {
        return this.types;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DmlType {
        INSERT,
        UPDATE,
        DELETE,
        UPDATE_NO_KEYS;

    }
}

