/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.load.DataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.load.TableTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

public class SchemaPerNodeDataLoaderFilter
implements IDataLoaderFilter {
    private IDbDialect dbDialect;
    private JdbcTemplate jdbcTemplate;
    private String tablePrefix;
    private String schemaPrefix;

    public boolean filterDelete(IDataLoaderContext context, String[] keyValues) {
        this.filter(context);
        return true;
    }

    public boolean filterInsert(IDataLoaderContext context, String[] columnValues) {
        this.filter(context);
        return true;
    }

    public boolean filterUpdate(IDataLoaderContext context, String[] columnValues, String[] keyValues) {
        this.filter(context);
        return true;
    }

    private void filter(IDataLoaderContext context) {
        if (!context.getTableName().startsWith(this.tablePrefix) && !context.getNodeId().equals(context.getTableTemplate().getTable().getSchema())) {
            ((DataLoaderContext)context).setTableTemplate(this.getTableTemplate(context));
        }
    }

    private TableTemplate getTableTemplate(IDataLoaderContext context) {
        TableTemplate tableTemplate = new TableTemplate(this.jdbcTemplate, this.dbDialect, context.getTableName(), null, false, this.schemaPrefix == null ? context.getNodeId() : this.schemaPrefix + context.getNodeId(), null);
        tableTemplate.setColumnNames(context.getColumnNames());
        tableTemplate.setKeyNames(context.getKeyNames());
        tableTemplate.setOldData(context.getOldData());
        return tableTemplate;
    }

    public boolean isAutoRegister() {
        return true;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setSchemaPrefix(String schemaPrefix) {
        this.schemaPrefix = schemaPrefix;
    }
}

