/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.load.TableTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

public class DuplicateTableDataLoaderFilter
implements IDataLoaderFilter {
    private static final ILog log = LogFactory.getLog(DuplicateTableDataLoaderFilter.class);
    private IDbDialect dbDialect;
    private JdbcTemplate jdbcTemplate;
    private TableTemplate tableTemplate;
    private String duplicateSchema;
    private String duplicateCatalog;
    private String duplicateTableName;
    private String originalTableName;

    public boolean filterDelete(IDataLoaderContext context, String[] keyValues) {
        if (context.getTableName().equals(this.originalTableName)) {
            TableTemplate tableTemplate = this.getTableTemplate(context);
            tableTemplate.insert(context, keyValues);
        }
        return true;
    }

    public boolean filterInsert(IDataLoaderContext context, String[] columnValues) {
        if (context.getTableName().equals(this.originalTableName)) {
            TableTemplate tableTemplate = this.getTableTemplate(context);
            tableTemplate.insert(context, columnValues);
        }
        return true;
    }

    public boolean filterUpdate(IDataLoaderContext context, String[] columnValues, String[] keyValues) {
        if (context.getTableName().equals(this.originalTableName)) {
            TableTemplate tableTemplate = this.getTableTemplate(context);
            tableTemplate.update(context, columnValues, keyValues);
        }
        return true;
    }

    private TableTemplate getTableTemplate(IDataLoaderContext context) {
        if (this.tableTemplate == null) {
            this.tableTemplate = new TableTemplate(this.jdbcTemplate, this.dbDialect, this.duplicateTableName, null, false, this.duplicateSchema, this.duplicateCatalog);
            this.tableTemplate.setColumnNames(context.getColumnNames());
            this.tableTemplate.setKeyNames(context.getKeyNames());
        }
        return this.tableTemplate;
    }

    public boolean isAutoRegister() {
        log.info("TableDuplicating", this.originalTableName, (this.duplicateCatalog != null ? this.duplicateCatalog + "." : "") + (this.duplicateSchema != null ? this.duplicateSchema + "." : "") + this.duplicateTableName);
        return true;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setOriginalTableName(String tableName) {
        this.originalTableName = tableName;
    }

    public void setDuplicateTableName(String duplicateTableName) {
        this.duplicateTableName = duplicateTableName;
    }

    public void setDuplicateSchema(String schema) {
        this.duplicateSchema = schema;
    }

    public void setDuplicateCatalog(String catalog) {
        this.duplicateCatalog = catalog;
    }
}

