/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.TableTemplate;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataLoaderContext
implements IDataLoaderContext {
    static final ILog log = LogFactory.getLog(DataLoaderContext.class);
    private String nodeId;
    private String tableName;
    private String schemaName;
    private String catalogName;
    private String channelId;
    private long batchId;
    private boolean isSkipping;
    private transient Map<String, TableTemplate> tableTemplateMap;
    private TableTemplate tableTemplate;
    private Map<String, Object> contextCache = new HashMap<String, Object>();
    private BinaryEncoding binaryEncoding = BinaryEncoding.NONE;
    private INodeService nodeService;
    private transient Node node;

    public DataLoaderContext(INodeService nodeService) {
        this();
        this.nodeService = nodeService;
    }

    public DataLoaderContext() {
        this.tableTemplateMap = new HashMap<String, TableTemplate>();
    }

    @Override
    public Node getNode() {
        if (this.node == null) {
            this.node = this.nodeService != null && this.nodeId != null ? this.nodeService.findNode(this.nodeId) : null;
        }
        return this.node;
    }

    @Override
    public TableTemplate getTableTemplate() {
        return this.tableTemplate;
    }

    public void setTableTemplate(TableTemplate tableTemplate) {
        this.tableTemplate = tableTemplate;
        this.tableTemplateMap.put(this.getTableName(), tableTemplate);
    }

    @Override
    public int getColumnIndex(String columnName) {
        String[] columnNames = this.tableTemplate.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnNames[i].equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getKeyIndex(String columnName) {
        String[] columnNames = this.tableTemplate.getKeyNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnNames[i].equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Table[] getAllTablesProcessed() {
        Collection<TableTemplate> templates = this.tableTemplateMap.values();
        Table[] tables = new Table[templates.size()];
        int i = 0;
        for (TableTemplate table : templates) {
            tables[i++] = table.getTable();
        }
        return tables;
    }

    @Override
    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
        this.isSkipping = false;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
        this.node = null;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.tableTemplate = this.tableTemplateMap.get(tableName);
    }

    @Override
    public String[] getOldData() {
        return this.tableTemplate != null ? this.tableTemplate.getOldData() : null;
    }

    @Override
    public boolean isSkipping() {
        return this.isSkipping;
    }

    public void setSkipping(boolean isSkipping) {
        this.isSkipping = isSkipping;
    }

    @Override
    public String[] getColumnNames() {
        return this.tableTemplate.getColumnNames();
    }

    public void setColumnNames(String[] columnNames) {
        this.tableTemplate.setColumnNames(columnNames);
    }

    public void setOldData(String[] oldData) {
        this.tableTemplate.setOldData(oldData);
    }

    @Override
    public String[] getKeyNames() {
        return this.tableTemplate.getKeyNames();
    }

    public void setKeyNames(String[] keyNames) {
        this.tableTemplate.setKeyNames(keyNames);
    }

    @Override
    public Map<String, Object> getContextCache() {
        return this.contextCache;
    }

    @Override
    public BinaryEncoding getBinaryEncoding() {
        return this.binaryEncoding;
    }

    public void setBinaryEncoding(BinaryEncoding binaryEncoding) {
        this.binaryEncoding = binaryEncoding;
    }

    public void setBinaryEncodingType(String encoding) {
        try {
            this.binaryEncoding = BinaryEncoding.valueOf(encoding);
        }
        catch (Exception ex) {
            log.warn("EncodingUnsupported", encoding);
        }
    }

    @Override
    public Object[] getOldObjectValues() {
        String[] oldData = this.getOldData();
        if (oldData != null) {
            return this.tableTemplate.getObjectValues(this, oldData);
        }
        return null;
    }

    @Override
    public Object[] getObjectValues(String[] values) {
        return this.tableTemplate.getObjectValues(this, values);
    }

    @Override
    public Object[] getObjectKeyValues(String[] values) {
        return this.tableTemplate.getObjectKeyValues(this, values);
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }
}

