/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.load.IBatchListener;
import org.jumpmind.symmetric.load.IDataLoader;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;

public class ConfigurationChangedFilter
implements IDataLoaderFilter,
IBatchListener,
IBuiltInExtensionPoint {
    static final ILog log = LogFactory.getLog(ConfigurationChangedFilter.class);
    final String CTX_KEY_RESYNC_NEEDED = "Resync." + ConfigurationChangedFilter.class.getSimpleName() + this.hashCode();
    final String CTX_KEY_FLUSH_CHANNELS_NEEDED = "FlushChannels." + ConfigurationChangedFilter.class.getSimpleName() + this.hashCode();
    private IParameterService parameterService;
    private IConfigurationService configurationService;
    private ITriggerRouterService triggerRouterService;
    private String tablePrefix;

    public boolean filterDelete(IDataLoaderContext context, String[] keyValues) {
        this.recordSyncNeeded(context);
        this.recordChannelFlushNeeded(context);
        return true;
    }

    public boolean filterInsert(IDataLoaderContext context, String[] columnValues) {
        this.recordSyncNeeded(context);
        this.recordChannelFlushNeeded(context);
        return true;
    }

    public boolean filterUpdate(IDataLoaderContext context, String[] columnValues, String[] keyValues) {
        this.recordSyncNeeded(context);
        this.recordChannelFlushNeeded(context);
        return true;
    }

    private void recordSyncNeeded(IDataLoaderContext context) {
        if (this.isSyncTriggersNeeded(context)) {
            context.getContextCache().put(this.CTX_KEY_RESYNC_NEEDED, true);
        }
    }

    private void recordChannelFlushNeeded(IDataLoaderContext context) {
        if (this.isChannelFlushNeeded(context)) {
            context.getContextCache().put(this.CTX_KEY_FLUSH_CHANNELS_NEEDED, true);
        }
    }

    private boolean isSyncTriggersNeeded(IDataLoaderContext context) {
        return this.matchesTable(context, "trigger") || this.matchesTable(context, "router") || this.matchesTable(context, "trigger_router");
    }

    private boolean isChannelFlushNeeded(IDataLoaderContext context) {
        return this.matchesTable(context, "channel");
    }

    private boolean matchesTable(IDataLoaderContext context, String tableSuffix) {
        return context.getTableName().equalsIgnoreCase(TableConstants.getTableName(this.tablePrefix, tableSuffix));
    }

    public boolean isAutoRegister() {
        return true;
    }

    public void batchComplete(IDataLoader loader, IncomingBatch batch) {
    }

    public void batchRolledback(IDataLoader loader, IncomingBatch batch, Exception ex) {
    }

    public void batchCommitted(IDataLoader loader, IncomingBatch batch) {
        if (loader.getContext().getContextCache().get(this.CTX_KEY_FLUSH_CHANNELS_NEEDED) != null) {
            log.info("ChannelFlushed");
            this.configurationService.reloadChannels();
        }
        if (loader.getContext().getContextCache().get(this.CTX_KEY_RESYNC_NEEDED) != null && this.parameterService.is("auto.sync.configuration")) {
            log.info("ConfigurationChanged");
            this.triggerRouterService.syncTriggers();
        }
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerService) {
        this.triggerRouterService = triggerService;
    }

    public void earlyCommit(IDataLoader loader, IncomingBatch batch) {
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

