/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.Set;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ext.IHeartbeatListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushHeartbeatListener
implements IHeartbeatListener,
IBuiltInExtensionPoint {
    private boolean enabled;
    private IDataService dataService;
    private INodeService nodeService;
    private IOutgoingBatchService outgoingBatchService;
    private long timeBetweenHeartbeats;

    @Override
    public void heartbeat(Node me, Set<Node> children) {
        if (this.enabled && !this.nodeService.isRegistrationServer() && !this.outgoingBatchService.isUnsentDataOnChannelForNode("config", me.getNodeId())) {
            this.dataService.insertHeartbeatEvent(me, false);
            for (Node node : children) {
                this.dataService.insertHeartbeatEvent(node, false);
            }
        }
    }

    @Override
    public long getTimeBetweenHeartbeatsInSeconds() {
        return this.timeBetweenHeartbeats;
    }

    public void setTimeBetweenHeartbeats(long timeBetweenHeartbeats) {
        this.timeBetweenHeartbeats = timeBetweenHeartbeats;
    }

    @Override
    public boolean isAutoRegister() {
        return this.enabled;
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setOutgoingBatchService(IOutgoingBatchService outgoingBatchService) {
        this.outgoingBatchService = outgoingBatchService;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

