/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.service.IParameterService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class JobManager
implements IJobManager,
BeanFactoryAware {
    final ILog log = LogFactory.getLog(JobManager.class);
    private Map<String, Timer> jobs;
    private BeanFactory beanFactory;
    private IParameterService parameterService;

    private void startJob(String name) {
        this.log.info("JobStarting", name);
        this.addTimer(name, (Timer)this.beanFactory.getBean(name));
    }

    public synchronized void addTimer(String timerName, Timer timer) {
        if (this.jobs == null) {
            this.jobs = new HashMap<String, Timer>();
        }
        this.jobs.put(timerName, timer);
    }

    public synchronized void startJobs() {
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.parameterService.getString("start.push.job"))) {
            this.startJob("pushJobTimer");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.parameterService.getString("start.pull.job"))) {
            this.startJob("pullJobTimer");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.parameterService.getString("start.route.job"))) {
            this.startJob("routingJobTimer");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.parameterService.getString("start.purge.job"))) {
            this.startJob("purgeJobTimer");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.parameterService.getString("start.heartbeat.job"))) {
            this.startJob("heartbeatJobTimer");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.parameterService.getString("start.synctriggers.job"))) {
            this.startJob("syncTriggersJobTimer");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.parameterService.getString("start.stat.flush.job"))) {
            this.startJob("statisticFlushJobTimer");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(this.parameterService.getString("start.watchdog.job"))) {
            this.startJob("watchdogJobTimer");
        }
    }

    public synchronized void stopJobs() {
        if (this.jobs != null) {
            for (Timer job : this.jobs.values()) {
                try {
                    job.cancel();
                }
                catch (RuntimeException e) {
                    this.log.error(e);
                }
            }
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

