/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ext.IOfflineServerListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;

public class DefaultOfflineServerListener
implements IOfflineServerListener,
IBuiltInExtensionPoint {
    protected INodeService nodeService;
    protected IOutgoingBatchService outgoingBatchService;
    protected static final ILog log = LogFactory.getLog(DefaultOfflineServerListener.class);

    public void clientNodeOffline(Node node) {
        log.warn("NodeOffline", node.getNodeId(), node.getHeartbeatTime(), node.getTimezoneOffset());
        node.setSyncEnabled(false);
        this.nodeService.updateNode(node);
        this.outgoingBatchService.markAllAsSentForNode(node);
        this.nodeService.deleteNodeSecurity(node.getNodeId());
    }

    public boolean isAutoRegister() {
        return true;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setOutgoingBatchService(IOutgoingBatchService outgoingBatchService) {
        this.outgoingBatchService = outgoingBatchService;
    }
}

