/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.Timer;
import java.util.TimerTask;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractJob
extends TimerTask
implements BeanFactoryAware,
BeanNameAware {
    DataSource dataSource;
    protected final ILog log = LogFactory.getLog(this.getClass());
    private boolean needsRescheduled;
    private String rescheduleDelayParameter;
    private BeanFactory beanFactory;
    protected IParameterService parameterService;
    private String beanName;
    private boolean requiresRegistration = true;
    private ISymmetricEngine engine;
    protected boolean rescheduleImmediately = false;
    private IJobManager jobManager;

    public boolean cancel() {
        this.log.info("JobCancelled", this.beanName);
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            block9: {
                try {
                    if (this.engine == null) {
                        this.engine = StandaloneSymmetricEngine.findEngineByName(this.parameterService.getString("engine.name"));
                    }
                    if (this.engine == null) {
                        this.log.info("SymmetricEngineMissing", this.beanName);
                        break block9;
                    }
                    if (this.engine.isStarted()) {
                        IRegistrationService service = (IRegistrationService)this.beanFactory.getBean("registrationService");
                        if (!this.requiresRegistration || this.requiresRegistration && service.isRegisteredWithServer()) {
                            this.doJob();
                        } else {
                            this.log.warn("SymmetricEngineNotRegistered");
                        }
                        break block9;
                    }
                    this.log.info("SymmetricEngineNotStarted");
                }
                catch (Throwable ex) {
                    this.log.error(ex);
                    Object var3_4 = null;
                    this.reschedule();
                }
            }
            Object var3_3 = null;
            this.reschedule();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.reschedule();
            throw throwable;
        }
    }

    abstract void doJob() throws Exception;

    protected void reschedule() {
        if (this.needsRescheduled && this.engine != null && (this.engine.isStarted() || this.engine.isStarting())) {
            String timerName = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1).toLowerCase();
            Timer timer = new Timer(timerName);
            timer.schedule((TimerTask)this.beanFactory.getBean(this.beanName), this.rescheduleImmediately ? 0L : this.parameterService.getLong(this.rescheduleDelayParameter));
            this.jobManager.addTimer(timerName, timer);
            this.rescheduleImmediately = false;
            this.log.debug("JobRescheduling", this.beanName, this.parameterService.getLong(this.rescheduleDelayParameter));
        } else if (this.needsRescheduled) {
            this.log.warn("Did not reschedule because the engine was not set.");
        }
    }

    protected void printDatabaseStats() {
        if (this.dataSource instanceof BasicDataSource) {
            BasicDataSource ds = (BasicDataSource)this.dataSource;
            this.log.debug("DatabaseStats", ds.getNumActive());
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isNeedsRescheduled() {
        return this.needsRescheduled;
    }

    public void setNeedsRescheduled(boolean needsRescheduled) {
        this.needsRescheduled = needsRescheduled;
    }

    public void setRescheduleDelayParameter(String rescheduleDelay) {
        this.rescheduleDelayParameter = rescheduleDelay;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setRequiresRegistration(boolean requiresRegistration) {
        this.requiresRegistration = requiresRegistration;
    }

    public void setJobManager(IJobManager jobManager) {
        this.jobManager = jobManager;
    }
}

