/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.IOfflineClientListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.NodeService;

public class DefaultOfflineClientListener
implements IOfflineClientListener,
IBuiltInExtensionPoint {
    protected final ILog log = LogFactory.getLog(this.getClass());
    protected IParameterService parameterService;
    protected INodeService nodeService;

    public void busy(Node remoteNode) {
        this.log.warn("TransportFailedConnectionBusy");
    }

    public void notAuthenticated(Node remoteNode) {
        this.log.warn("AuthenticationFailed");
    }

    public void offline(Node remoteNode) {
        this.log.warn("TransportFailedConnectionUnavailable", remoteNode.getSyncUrl() == null ? this.parameterService.getRegistrationUrl() : remoteNode.getSyncUrl());
    }

    public void syncDisabled(Node remoteNode) {
        this.log.warn("SyncDisabled");
        this.nodeService.deleteIdentity();
    }

    public void registrationRequired(Node remoteNode) {
        this.log.warn("RegistrationRequired");
        this.nodeService.deleteIdentity();
    }

    public boolean isAutoRegister() {
        return true;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

