/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.integrate.IPublisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.jms.core.JmsTemplate;

public class SimpleJmsPublisher
implements IPublisher,
BeanFactoryAware {
    static final ILog log = LogFactory.getLog(SimpleJmsPublisher.class);
    private BeanFactory beanFactory;
    private String jmsTemplateBeanName;
    public boolean enabled = true;

    public void publish(ICacheContext ctx, String text) {
        log.debug("TextPublishing", text);
        JmsTemplate jmsTemplate = (JmsTemplate)this.beanFactory.getBean(this.jmsTemplateBeanName);
        if (this.enabled) {
            jmsTemplate.convertAndSend((Object)text);
        } else {
            log.warn("TextPublishingFailed");
        }
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void setJmsTemplateBeanName(String jmsTemplateBeanName) {
        this.jmsTemplateBeanName = jmsTemplateBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

