/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.ext.IExtensionPoint;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.integrate.IPublisher;
import org.jumpmind.symmetric.model.DataEventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractXmlPublisherExtensionPoint
implements IExtensionPoint,
INodeGroupExtensionPoint {
    protected final ILog log = LogFactory.getLog(this.getClass());
    protected final String XML_CACHE = "XML_CACHE_" + this.hashCode();
    private String[] nodeGroups;
    private boolean autoRegister = true;
    protected IPublisher publisher;
    protected Set<String> tableNamesToPublishAsGroup;
    protected String xmlTagNameToUseForGroup = "batch";
    protected List<String> groupByColumnNames;
    protected Format xmlFormat;
    protected ITimeGenerator timeStringGenerator = new ITimeGenerator(){

        public String getTime() {
            return Long.toString(System.currentTimeMillis());
        }
    };

    public AbstractXmlPublisherExtensionPoint() {
        this.xmlFormat = Format.getCompactFormat();
        this.xmlFormat.setOmitDeclaration(true);
    }

    protected static final Namespace getXmlNamespace() {
        return Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    }

    protected Map<String, Element> getXmlCache(ICacheContext ctx) {
        Map<String, Object> cache = ctx.getContextCache();
        HashMap xmlCache = (HashMap)cache.get(this.XML_CACHE);
        if (xmlCache == null) {
            xmlCache = new HashMap();
            cache.put(this.XML_CACHE, xmlCache);
        }
        return xmlCache;
    }

    protected boolean doesXmlExistToPublish(ICacheContext ctx) {
        Map<String, Object> cache = ctx.getContextCache();
        Map xmlCache = (Map)cache.get(this.XML_CACHE);
        return xmlCache != null && xmlCache.size() > 0;
    }

    protected void finalizeXmlAndPublish(ICacheContext ctx) {
        Map<String, Element> ctxCache = this.getXmlCache(ctx);
        Collection<Element> buffers = ctxCache.values();
        Iterator<Element> iterator = buffers.iterator();
        while (iterator.hasNext()) {
            String xml = new XMLOutputter(this.xmlFormat).outputString(new Document(iterator.next()));
            this.log.debug("XMLSending", xml);
            iterator.remove();
            this.publisher.publish(ctx, xml.toString());
        }
    }

    protected void toXmlElement(DataEventType dml, Element xml, String tableName, String[] columnNames, String[] data, String[] keyNames, String[] keys) {
        Element row = new Element("row");
        xml.addContent((Content)row);
        row.setAttribute("entity", tableName);
        row.setAttribute("dml", dml.getCode());
        String[] colNames = null;
        if (data == null) {
            colNames = keyNames;
            data = keys;
        } else {
            colNames = columnNames;
        }
        for (int i = 0; i < data.length; ++i) {
            String col = colNames[i];
            Element dataElement = new Element("data");
            row.addContent((Content)dataElement);
            dataElement.setAttribute("key", col);
            if (data[i] != null) {
                dataElement.setText(data[i]);
                continue;
            }
            dataElement.setAttribute("nil", "true", AbstractXmlPublisherExtensionPoint.getXmlNamespace());
        }
    }

    protected void addFormattedExtraGroupAttributes(ICacheContext ctx, Element xml) {
        xml.setAttribute("nodeid", ctx.getNodeId());
        if (this.timeStringGenerator != null) {
            xml.setAttribute("time", this.timeStringGenerator.getTime());
        }
    }

    protected Element getXmlFromCache(ICacheContext ctx, String[] columnNames, String[] data, String[] keyNames, String[] keys) {
        Element xml = null;
        Map<String, Element> ctxCache = this.getXmlCache(ctx);
        String txId = this.toXmlGroupId(columnNames, data, keyNames, keys);
        if (txId != null && (xml = ctxCache.get(txId)) == null) {
            xml = new Element(this.xmlTagNameToUseForGroup);
            xml.addNamespaceDeclaration(AbstractXmlPublisherExtensionPoint.getXmlNamespace());
            xml.setAttribute("id", txId);
            this.addFormattedExtraGroupAttributes(ctx, xml);
            ctxCache.put(txId, xml);
        }
        return xml;
    }

    protected String toXmlGroupId(String[] columnNames, String[] data, String[] keyNames, String[] keys) {
        if (this.groupByColumnNames != null) {
            int index;
            Object[] columns;
            StringBuilder id = new StringBuilder();
            if (keys != null) {
                columns = keyNames;
                for (String col : this.groupByColumnNames) {
                    index = ArrayUtils.indexOf((Object[])columns, (Object)col, (int)0);
                    if (index >= 0) {
                        id.append(data[index]);
                        continue;
                    }
                    id = new StringBuilder();
                    break;
                }
            }
            if (id.length() == 0) {
                columns = columnNames;
                for (String col : this.groupByColumnNames) {
                    index = ArrayUtils.indexOf((Object[])columns, (Object)col, (int)0);
                    if (index >= 0) {
                        id.append(data[index]);
                        continue;
                    }
                    return null;
                }
            }
            if (id.length() > 0) {
                return id.toString().replaceAll("-", "");
            }
        } else {
            this.log.warn("You did not specify 'groupByColumnNames'.  We cannot find any matches in the data to publish as XML if you don't.  You might as well turn off this filter!");
        }
        return null;
    }

    @Override
    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    @Override
    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroups;
    }

    public void setNodeGroups(String[] nodeGroups) {
        this.nodeGroups = nodeGroups;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public void setPublisher(IPublisher publisher) {
        this.publisher = publisher;
    }

    public void setTimeStringGenerator(ITimeGenerator timeStringGenerator) {
        this.timeStringGenerator = timeStringGenerator;
    }

    public void setXmlFormat(Format xmlFormat) {
        this.xmlFormat = xmlFormat;
    }

    public void setTableNamesToPublishAsGroup(Set<String> tableNamesToPublishAsGroup) {
        this.tableNamesToPublishAsGroup = tableNamesToPublishAsGroup;
    }

    public void setTableNameToPublish(String tableName) {
        this.tableNamesToPublishAsGroup = new HashSet<String>(1);
        this.tableNamesToPublishAsGroup.add(tableName);
    }

    public void setXmlTagNameToUseForGroup(String xmlTagNameToUseForGroup) {
        this.xmlTagNameToUseForGroup = xmlTagNameToUseForGroup;
    }

    public void setGroupByColumnNames(List<String> groupByColumnNames) {
        this.groupByColumnNames = groupByColumnNames;
    }

    public static interface ITimeGenerator {
        public String getTime();
    }
}

