/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import java.util.Map;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.integrate.IPublisher;
import org.jumpmind.symmetric.integrate.IPublisherFilter;
import org.jumpmind.symmetric.load.IDataLoader;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractTextPublisherDataLoaderFilter
implements IPublisherFilter,
INodeGroupExtensionPoint,
BeanNameAware {
    private final ILog log = LogFactory.getLog(this.getClass());
    private final String MSG_CACHE = "msg_CACHE" + this.hashCode();
    protected IPublisher publisher;
    private boolean loadDataInTargetDatabase = true;
    protected String tableName;
    private boolean autoRegister = true;
    private String[] nodeGroupIdsToApplyTo;
    private int messagesSinceLastLogOutput = 0;
    private long minTimeInMsBetweenLogOutput = 30000L;
    private long lastTimeInMsOutputLogged = System.currentTimeMillis();
    private String beanName;

    protected abstract String addTextHeader(IDataLoaderContext var1);

    protected abstract String addTextElementForDelete(IDataLoaderContext var1, String[] var2);

    protected abstract String addTextElementForUpdate(IDataLoaderContext var1, String[] var2, String[] var3);

    protected abstract String addTextElementForInsert(IDataLoaderContext var1, String[] var2);

    protected abstract String addTextFooter(IDataLoaderContext var1);

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public boolean filterDelete(IDataLoaderContext ctx, String[] keys) {
        String msg;
        if (this.tableName != null && this.tableName.equals(ctx.getTableName()) && (msg = this.addTextElementForDelete(ctx, keys)) != null) {
            this.getFromCache(ctx).append(msg);
        }
        return this.loadDataInTargetDatabase;
    }

    public boolean filterUpdate(IDataLoaderContext ctx, String[] data, String[] keys) {
        String msg;
        if (this.tableName != null && this.tableName.equals(ctx.getTableName()) && (msg = this.addTextElementForUpdate(ctx, data, keys)) != null) {
            this.getFromCache(ctx).append(msg);
        }
        return this.loadDataInTargetDatabase;
    }

    public boolean filterInsert(IDataLoaderContext ctx, String[] data) {
        String msg;
        if (this.tableName != null && this.tableName.equals(ctx.getTableName()) && (msg = this.addTextElementForInsert(ctx, data)) != null) {
            this.getFromCache(ctx).append(msg);
        }
        return this.loadDataInTargetDatabase;
    }

    protected StringBuilder getFromCache(IDataLoaderContext ctx) {
        Map<String, Object> cache = ctx.getContextCache();
        StringBuilder msgCache = (StringBuilder)cache.get(this.MSG_CACHE);
        if (msgCache == null) {
            msgCache = new StringBuilder(this.addTextHeader(ctx));
            cache.put(this.MSG_CACHE, msgCache);
        }
        return msgCache;
    }

    protected boolean doesTextExistToPublish(IDataLoaderContext ctx) {
        Map<String, Object> cache = ctx.getContextCache();
        StringBuilder msgCache = (StringBuilder)cache.get(this.MSG_CACHE);
        return msgCache != null && msgCache.length() > 0;
    }

    private void finalizeAndPublish(IDataLoaderContext ctx) {
        StringBuilder msg = this.getFromCache(ctx);
        if (msg.length() > 0) {
            msg.append(this.addTextFooter(ctx));
            this.log.debug("TextMessagePublishing", msg);
            ctx.getContextCache().remove(this.MSG_CACHE);
            this.publisher.publish(ctx, msg.toString());
        }
    }

    public void batchComplete(IDataLoader loader, IncomingBatch batch) {
        IDataLoaderContext ctx = loader.getContext();
        if (this.doesTextExistToPublish(ctx)) {
            this.finalizeAndPublish(ctx);
            this.logCount();
        }
    }

    protected void logCount() {
        ++this.messagesSinceLastLogOutput;
        long timeInMsSinceLastLogOutput = System.currentTimeMillis() - this.lastTimeInMsOutputLogged;
        if (timeInMsSinceLastLogOutput > this.minTimeInMsBetweenLogOutput) {
            this.log.info("TextMessagePublished", this.beanName, this.messagesSinceLastLogOutput, timeInMsSinceLastLogOutput);
            this.lastTimeInMsOutputLogged = System.currentTimeMillis();
            this.messagesSinceLastLogOutput = 0;
        }
    }

    public void setLoadDataInTargetDatabase(boolean loadDataInTargetDatabase) {
        this.loadDataInTargetDatabase = loadDataInTargetDatabase;
    }

    public void setPublisher(IPublisher publisher) {
        this.publisher = publisher;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdToApplyTo(String nodeGroupdId) {
        this.nodeGroupIdsToApplyTo = new String[]{nodeGroupdId};
    }

    public void setMessagesSinceLastLogOutput(int messagesSinceLastLogOutput) {
        this.messagesSinceLastLogOutput = messagesSinceLastLogOutput;
    }

    public void setMinTimeInMsBetweenLogOutput(long timeInMsBetweenLogOutput) {
        this.minTimeInMsBetweenLogOutput = timeInMsBetweenLogOutput;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void batchCommitted(IDataLoader loader, IncomingBatch batch) {
    }

    public void batchRolledback(IDataLoader loader, IncomingBatch batch, Exception ex) {
    }

    public void earlyCommit(IDataLoader loader, IncomingBatch batch) {
    }
}

