/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.csv.AbstractStreamDataCommand;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.ITriggerRouterService;

class StreamReloadDataCommand
extends AbstractStreamDataCommand {
    private IDataExtractorService dataExtractorService;
    private ITriggerRouterService triggerRouterService;
    private INodeService nodeService;

    StreamReloadDataCommand() {
    }

    public void execute(BufferedWriter out, Data data, String routerId, DataExtractorContext context) throws IOException {
        String triggerId = data.getTriggerHistory().getTriggerId();
        TriggerRouter triggerRouter = this.triggerRouterService.findTriggerRouterById(triggerId, routerId);
        if (triggerRouter != null) {
            if (data.getRowData() != null) {
                triggerRouter.setInitialLoadSelect(data.getRowData());
            }
            Node node = this.nodeService.findNode(context.getBatch().getNodeId());
            this.dataExtractorService.extractInitialLoadWithinBatchFor(node, triggerRouter, out, context);
            out.flush();
        } else {
            this.log.error("TriggerRouterUnavailable", triggerId, routerId);
        }
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerService) {
        this.triggerRouterService = triggerService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public boolean isTriggerHistoryRequired() {
        return true;
    }
}

