/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.csv.CsvExtractor14;
import org.jumpmind.symmetric.extract.csv.IStreamDataCommand;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.util.CsvUtils;

public class CsvExtractor16
extends CsvExtractor14 {
    public void write(BufferedWriter writer, Data data, String routerId, DataExtractorContext context) throws IOException {
        IStreamDataCommand cmd = (IStreamDataCommand)this.dictionary.get(data.getEventType().getCode());
        if (cmd == null) {
            throw new SymmetricException("DataExtractorCouldNotFindStreamCommand", data.getEventType().getCode());
        }
        if (cmd.isTriggerHistoryRequired()) {
            this.preprocessTable(data, routerId, writer, context);
        }
        cmd.execute(writer, data, routerId, context);
    }

    public void preprocessTable(Data data, String routerId, BufferedWriter out, DataExtractorContext context) throws IOException {
        if (data.getTriggerHistory() == null) {
            throw new RuntimeException("Missing trigger_hist for table " + data.getTableName() + ": try running syncTriggers() or restarting SymmetricDS");
        }
        if (!data.getTriggerHistory().getSourceTableName().toLowerCase().equals(data.getTableName().toLowerCase())) {
            throw new RuntimeException(String.format("The table name captured in the data table (%1$s) does not match the table name recorded in the trigger_hist table (%2$s).  Please drop the symmetric triggers on %1$s and restart the server", data.getTableName(), data.getTriggerHistory().getSourceTableName()));
        }
        String triggerHistId = Integer.toString(data.getTriggerHistory().getTriggerHistoryId()).intern();
        if (!context.getHistoryRecordsWritten().contains(triggerHistId)) {
            CsvUtils.write(out, "table", ", ", data.getTableName());
            out.newLine();
            CsvUtils.write(out, "keys", ", ", data.getTriggerHistory().getPkColumnNames());
            out.newLine();
            CsvUtils.write(out, "columns", ", ", data.getTriggerHistory().getColumnNames());
            out.newLine();
            context.getHistoryRecordsWritten().add(triggerHistId);
        } else if (!context.isLastTable(data.getTableName())) {
            CsvUtils.write(out, "table", ", ", data.getTableName());
            out.newLine();
        }
        if (data.getEventType() == DataEventType.UPDATE && data.getOldData() != null && this.parameterService.is("dataextractor.old.data.enable")) {
            CsvUtils.write(out, "old", ", ", data.getOldData());
            out.newLine();
        }
        context.setLastTableName(data.getTableName());
    }
}

