/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.IDataExtractor;
import org.jumpmind.symmetric.extract.csv.IStreamDataCommand;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.CsvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvExtractor10
implements IDataExtractor {
    private Map<String, IStreamDataCommand> dictionary = null;
    private IParameterService parameterService;
    private String tablePrefix;

    @Override
    public void init(BufferedWriter writer, DataExtractorContext context) throws IOException {
        CsvUtils.write(writer, "nodeid", ", ", this.parameterService.getString("external.id"));
        writer.newLine();
    }

    @Override
    public void begin(OutgoingBatch batch, BufferedWriter writer) throws IOException {
        CsvUtils.write(writer, "batch", ", ", Long.toString(batch.getBatchId()));
        writer.newLine();
    }

    @Override
    public void commit(OutgoingBatch batch, BufferedWriter writer) throws IOException {
        CsvUtils.write(writer, "commit", ", ", Long.toString(batch.getBatchId()));
        writer.newLine();
    }

    @Override
    public void write(BufferedWriter writer, Data data, String routerId, DataExtractorContext context) throws IOException {
        this.preprocessTable(data, routerId, writer, context);
        this.dictionary.get(data.getEventType().getCode()).execute(writer, data, routerId, context);
    }

    @Override
    public void preprocessTable(Data data, String routerId, BufferedWriter out, DataExtractorContext context) throws IOException {
        String historyId = Integer.toString(data.getTriggerHistory().getTriggerHistoryId()).intern();
        if (!context.getHistoryRecordsWritten().contains(historyId)) {
            CsvUtils.write(out, "table, ", data.getTableName());
            out.newLine();
            CsvUtils.write(out, "keys, ", data.getTriggerHistory().getPkColumnNames());
            out.newLine();
            String columns = data.getTriggerHistory().getColumnNames();
            if (data.getTableName().equalsIgnoreCase(this.tablePrefix + "_node_security")) {
                columns = columns.replaceFirst(",node_password,", ",password,");
                columns = columns.replaceFirst(",NODE_PASSWORD,", ",PASSWORD,");
            }
            CsvUtils.write(out, "columns, ", columns);
            out.newLine();
            context.getHistoryRecordsWritten().add(historyId);
        } else if (!context.isLastTable(data.getTableName())) {
            CsvUtils.write(out, "table, ", data.getTableName());
            out.newLine();
        }
        context.setLastTableName(data.getTableName());
    }

    public void setDictionary(Map<String, IStreamDataCommand> dictionary) {
        this.dictionary = dictionary;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public String getLegacyTableName(String currentTableName) {
        return currentTableName;
    }
}

