/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.csv.CsvExtractor16;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.util.CsvUtils;

public class CsvExtractor
extends CsvExtractor16 {
    protected ITriggerRouterService triggerRouterService;

    public void init(BufferedWriter writer, DataExtractorContext context) throws IOException {
        super.init(writer, context);
        CsvUtils.write(writer, "binary", ", ", this.dbDialect.getBinaryEncoding().name());
        writer.newLine();
    }

    public void begin(OutgoingBatch batch, BufferedWriter writer) throws IOException {
        CsvUtils.write(writer, "channel", ", ", batch.getChannelId());
        writer.newLine();
        CsvUtils.write(writer, "batch", ", ", Long.toString(batch.getBatchId()));
        writer.newLine();
    }

    public void preprocessTable(Data data, String routerId, BufferedWriter out, DataExtractorContext context) throws IOException {
        if (data.getTriggerHistory() == null) {
            throw new RuntimeException("Missing trigger_hist for table " + data.getTableName() + ": try running syncTriggers() or restarting SymmetricDS");
        }
        if (!data.getTriggerHistory().getSourceTableName().toLowerCase().equals(data.getTableName().toLowerCase())) {
            throw new RuntimeException(String.format("The table name captured in the data table (%1$s) does not match the table name recorded in the trigger_hist table (%2$s).  Please drop the symmetric triggers on %1$s and restart the server", data.getTableName(), data.getTriggerHistory().getSourceTableName()));
        }
        String triggerHistoryId = Integer.toString(data.getTriggerHistory().getTriggerHistoryId()).intern();
        if (!context.getHistoryRecordsWritten().contains(triggerHistoryId)) {
            this.writeTable(data, routerId, out);
            CsvUtils.write(out, "keys", ", ", data.getTriggerHistory().getPkColumnNames());
            out.newLine();
            CsvUtils.write(out, "columns", ", ", data.getTriggerHistory().getColumnNames());
            out.newLine();
            context.getHistoryRecordsWritten().add(triggerHistoryId);
        } else if (!context.isLastTable(data.getTableName())) {
            this.writeTable(data, routerId, out);
        }
        if (data.getEventType() == DataEventType.UPDATE && data.getOldData() != null && this.parameterService.is("dataextractor.old.data.enable")) {
            CsvUtils.write(out, "old", ", ", data.getOldData());
            out.newLine();
        }
        context.setLastTableName(data.getTableName());
    }

    protected void writeTable(Data data, String routerId, BufferedWriter out) throws IOException {
        Router router = this.triggerRouterService.getRouterByIdForCurrentNode(routerId, false);
        String schemaName = router == null || router.getTargetSchemaName() == null ? "" : router.getTargetSchemaName();
        CsvUtils.write(out, "schema", ", ", schemaName);
        out.newLine();
        String catalogName = router == null || router.getTargetCatalogName() == null ? "" : router.getTargetCatalogName();
        CsvUtils.write(out, "catalog", ", ", catalogName);
        out.newLine();
        String tableName = router == null || router.getTargetTableName() == null ? data.getTableName() : router.getTargetTableName();
        CsvUtils.write(out, "table", ", ", tableName);
        out.newLine();
    }

    public void setTriggerRouterService(ITriggerRouterService triggerRouterService) {
        this.triggerRouterService = triggerRouterService;
    }

    public String getLegacyTableName(String currentTableName) {
        return currentTableName;
    }
}

