/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ext;

import java.util.List;
import java.util.TreeMap;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.config.INodeIdGenerator;
import org.jumpmind.symmetric.config.IParameterFilter;
import org.jumpmind.symmetric.config.ITriggerCreationListener;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ext.IExtensionPoint;
import org.jumpmind.symmetric.ext.IExtensionPointManager;
import org.jumpmind.symmetric.ext.IHeartbeatListener;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.ext.IOfflineServerListener;
import org.jumpmind.symmetric.extract.IExtractorFilter;
import org.jumpmind.symmetric.io.IOfflineClientListener;
import org.jumpmind.symmetric.load.IBatchListener;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.load.IReloadListener;
import org.jumpmind.symmetric.load.ITableColumnFilter;
import org.jumpmind.symmetric.route.IBatchAlgorithm;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOfflineDetectorService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.transport.IAcknowledgeEventListener;
import org.jumpmind.symmetric.transport.ISyncUrlExtension;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionPointManager
implements IExtensionPointManager,
BeanFactoryAware,
BeanFactoryPostProcessor {
    final ILog log = LogFactory.getLog(this.getClass());
    private IDataLoaderService dataLoaderService;
    private IDataService dataService;
    private IDataExtractorService dataExtractorService;
    private IParameterService parameterService;
    private INodeService nodeService;
    private IAcknowledgeService acknowledgeService;
    private List<IOfflineDetectorService> offlineDetectorServices;
    private IRegistrationService registrationService;
    private ITriggerRouterService triggerRouterService;
    private ITransportManager transportManager;
    private IRouterService routingService;
    private BeanFactory beanFactory;
    private boolean initialized = false;
    private boolean postProcessEnabled = true;

    @Override
    public void register() throws BeansException {
        this.postProcessEnabled = true;
        ConfigurableListableBeanFactory cfgBeanFactory = (ConfigurableListableBeanFactory)this.beanFactory;
        this.postProcessBeanFactory(cfgBeanFactory);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory cfgBeanFactory) throws BeansException {
        if (!this.initialized && this.postProcessEnabled) {
            TreeMap extensions = new TreeMap();
            extensions.putAll(cfgBeanFactory.getBeansOfType(IExtensionPoint.class));
            if (cfgBeanFactory.getParentBeanFactory() != null && cfgBeanFactory.getParentBeanFactory() instanceof ListableBeanFactory) {
                extensions.putAll(((ListableBeanFactory)cfgBeanFactory.getParentBeanFactory()).getBeansOfType(IExtensionPoint.class));
            }
            for (String beanName : extensions.keySet()) {
                IExtensionPoint ext = (IExtensionPoint)extensions.get(beanName);
                if (!ext.isAutoRegister()) continue;
                boolean registerExtension = false;
                if (ext instanceof INodeGroupExtensionPoint) {
                    String nodeGroupId = this.parameterService.getNodeGroupId();
                    INodeGroupExtensionPoint nodeExt = (INodeGroupExtensionPoint)((Object)ext);
                    String[] ids = nodeExt.getNodeGroupIdsToApplyTo();
                    if (ids != null) {
                        for (String targetNodeGroupId : ids) {
                            if (!nodeGroupId.equals(targetNodeGroupId)) continue;
                            registerExtension = true;
                        }
                    } else {
                        registerExtension = true;
                    }
                } else {
                    registerExtension = true;
                }
                if (!registerExtension) continue;
                this.registerExtension(beanName, ext);
            }
            this.initialized = true;
        }
    }

    private void registerExtension(String beanName, IExtensionPoint ext) {
        if (ext instanceof IBuiltInExtensionPoint) {
            this.log.debug("ExtensionRegistering", beanName, ext.getClass().getSimpleName());
        } else {
            this.log.info("ExtensionRegistering", beanName, ext.getClass().getSimpleName());
        }
        if (ext instanceof ISyncUrlExtension) {
            this.transportManager.addExtensionSyncUrlHandler(beanName, (ISyncUrlExtension)ext);
        }
        if (ext instanceof INodePasswordFilter) {
            this.nodeService.setNodePasswordFilter((INodePasswordFilter)ext);
            this.registrationService.setNodePasswordFilter((INodePasswordFilter)ext);
        }
        if (ext instanceof IAcknowledgeEventListener) {
            this.acknowledgeService.addAcknowledgeEventListener((IAcknowledgeEventListener)ext);
        }
        if (ext instanceof ITriggerCreationListener) {
            this.triggerRouterService.addTriggerCreationListeners((ITriggerCreationListener)ext);
        }
        if (ext instanceof IBatchListener) {
            this.dataLoaderService.addBatchListener((IBatchListener)ext);
        }
        if (ext instanceof IHeartbeatListener) {
            this.dataService.addHeartbeatListener((IHeartbeatListener)ext);
        }
        if (ext instanceof IDataLoaderFilter) {
            this.dataLoaderService.addDataLoaderFilter((IDataLoaderFilter)ext);
        }
        if (ext instanceof IColumnFilter) {
            if (ext instanceof ITableColumnFilter) {
                ITableColumnFilter tableColumnFilter = (ITableColumnFilter)ext;
                if (tableColumnFilter.getTables() != null) {
                    String[] tables;
                    for (String table : tables = tableColumnFilter.getTables()) {
                        this.dataLoaderService.addColumnFilter(table, tableColumnFilter);
                    }
                }
            } else {
                throw new UnsupportedOperationException("IColumnFilter cannot be auto registered.  Please use " + ITableColumnFilter.class.getName() + " instead.");
            }
        }
        if (ext instanceof IReloadListener) {
            this.dataService.addReloadListener((IReloadListener)ext);
        }
        if (ext instanceof IParameterFilter) {
            this.parameterService.setParameterFilter((IParameterFilter)ext);
        }
        if (ext instanceof IExtractorFilter) {
            this.dataExtractorService.addExtractorFilter((IExtractorFilter)ext);
        }
        if (ext instanceof INodeIdGenerator) {
            this.nodeService.setNodeIdGenerator((INodeIdGenerator)ext);
        }
        if (ext instanceof IDataRouter) {
            this.routingService.addDataRouter(beanName, (IDataRouter)ext);
        }
        if (ext instanceof IBatchAlgorithm) {
            this.routingService.addBatchAlgorithm(beanName, (IBatchAlgorithm)ext);
        }
        if (ext instanceof IOfflineClientListener) {
            for (IOfflineDetectorService service : this.offlineDetectorServices) {
                service.addOfflineListener((IOfflineClientListener)ext);
            }
        }
        if (ext instanceof IOfflineServerListener) {
            this.nodeService.addOfflineServerListener((IOfflineServerListener)ext);
        }
    }

    public void setDataLoaderService(IDataLoaderService dataLoaderService) {
        this.dataLoaderService = dataLoaderService;
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAcknowledgeService(IAcknowledgeService acknowledgeService) {
        this.acknowledgeService = acknowledgeService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setTransportManager(ITransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public void setRoutingService(IRouterService routingService) {
        this.routingService = routingService;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerService) {
        this.triggerRouterService = triggerService;
    }

    public void setOfflineDetectorServices(List<IOfflineDetectorService> offlineDetectorServices) {
        this.offlineDetectorServices = offlineDetectorServices;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setPostProcessEnabled(boolean postProcessEnabled) {
        this.postProcessEnabled = postProcessEnabled;
    }
}

