/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddlutils.sqlite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.ColumnChange;
import org.apache.ddlutils.alteration.ColumnDataTypeChange;
import org.apache.ddlutils.alteration.ColumnRequiredChange;
import org.apache.ddlutils.alteration.ColumnSizeChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.SqlBuilder;

public class SqLiteBuilder
extends SqlBuilder {
    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE IF EXISTS ");
        this.printIdentifier(this.getTableName(table));
        this.printEndOfStatement();
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        if (!column.isPrimaryKey()) {
            this.print("PRIMARY KEY AUTOINCREMENT");
        }
    }

    public SqLiteBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    public String getSelectLastIdentityValues(Table table) {
        return "CALL IDENTITY()";
    }

    public void writeExternalIndexDropStmt(Table table, Index index) throws IOException {
        this.print("DROP INDEX IF EXISTS ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    protected void processTableStructureChanges(Database currentModel, Database desiredModel, CreationParameters params, Collection changes) throws IOException {
        TableChange change;
        for (TableChange change2 : changes) {
            if (!(change2 instanceof RemoveColumnChange) || !((RemoveColumnChange)change2).getColumn().isPrimaryKey()) continue;
            return;
        }
        ArrayList<TableChange> addColumnChanges = new ArrayList<TableChange>();
        Iterator changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = (TableChange)changeIt.next();
            if (!(change instanceof AddColumnChange)) continue;
            addColumnChanges.add(change);
            changeIt.remove();
        }
        changeIt = addColumnChanges.listIterator(addColumnChanges.size());
        while (changeIt.hasPrevious()) {
            AddColumnChange addColumnChange = (AddColumnChange)changeIt.previous();
            this.processChange(currentModel, desiredModel, addColumnChange);
            changeIt.remove();
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = (TableChange)changeIt.next();
            if (!(change instanceof RemoveColumnChange)) continue;
            RemoveColumnChange removeColumnChange = (RemoveColumnChange)change;
            this.processChange(currentModel, desiredModel, removeColumnChange);
            changeIt.remove();
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = (TableChange)changeIt.next();
            if (!(change instanceof ColumnChange)) continue;
            boolean needsAlter = true;
            if (change instanceof ColumnDataTypeChange) {
                ColumnDataTypeChange dataTypeChange = (ColumnDataTypeChange)change;
                if (dataTypeChange.getChangedColumn().getTypeCode() == 3 && dataTypeChange.getNewTypeCode() == 2) {
                    needsAlter = false;
                }
                if (dataTypeChange.getChangedColumn().getTypeCode() == 5 && dataTypeChange.getNewTypeCode() == -6) {
                    needsAlter = false;
                }
                if (dataTypeChange.getChangedColumn().getTypeCode() == 12 && dataTypeChange.getNewTypeCode() == -1) {
                    needsAlter = false;
                }
            }
            if (change instanceof ColumnSizeChange) {
                ColumnSizeChange sizeChange = (ColumnSizeChange)change;
                if (sizeChange.getNewScale() == 0 && sizeChange.getNewSize() == 0) {
                    needsAlter = false;
                } else if (sizeChange.getNewSize() == sizeChange.getChangedColumn().getSizeAsInt() && sizeChange.getNewScale() == sizeChange.getChangedColumn().getScale()) {
                    needsAlter = false;
                }
            }
            if (needsAlter) {
                this.processAlterColumn(currentModel, (ColumnChange)change);
            }
            changeIt.remove();
        }
    }

    protected void processAlterColumn(Database currentModel, ColumnChange columnChange) throws IOException {
        columnChange.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(columnChange.getChangedTable()));
        this.printIndent();
        this.print("ALTER COLUMN ");
        if (columnChange instanceof ColumnRequiredChange) {
            ColumnRequiredChange columnRequiredChange = (ColumnRequiredChange)columnChange;
            this.printlnIdentifier(this.getColumnName(columnChange.getChangedColumn()));
            this.printIndent();
            if (columnRequiredChange.getChangedColumn().isRequired()) {
                this.print(" SET NOT NULL ");
            } else {
                this.print(" SET NULL ");
            }
        } else {
            this.writeColumn(columnChange.getChangedTable(), columnChange.getChangedColumn());
        }
        this.printEndOfStatement();
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn());
        if (change.getNextColumn() != null) {
            this.print(" BEFORE ");
            this.printIdentifier(this.getColumnName(change.getNextColumn()));
        }
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()));
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }

    protected void writeColumnDefaultValueStmt(Table table, Column column) throws IOException {
        Object parsedDefault = column.getParsedDefaultValue();
        if (parsedDefault != null) {
            if (!(this.getPlatformInfo().isDefaultValuesForLongTypesSupported() || column.getTypeCode() != -4 && column.getTypeCode() != -1)) {
                throw new ModelException("The platform does not support default values for LONGVARCHAR or LONGVARBINARY columns");
            }
            if (this.isValidDefaultValue(column.getDefaultValue(), column.getTypeCode())) {
                this.print(" DEFAULT ");
                this.writeColumnDefaultValue(table, column);
            }
        } else if (this.getPlatformInfo().isDefaultValueUsedForIdentitySpec() && column.isAutoIncrement()) {
            this.print(" DEFAULT ");
            this.writeColumnDefaultValue(table, column);
        } else if (!StringUtils.isBlank((String)column.getDefaultValue())) {
            this.print(" DEFAULT ");
            this.writeColumnDefaultValue(table, column);
        }
    }

    protected void printDefaultValue(Object defaultValue, int typeCode) throws IOException {
        if (defaultValue != null) {
            boolean shouldUseQuotes;
            String defaultValueStr = defaultValue.toString();
            boolean bl = shouldUseQuotes = !TypeMap.isNumericType((int)typeCode) && !defaultValueStr.startsWith("TO_DATE(") && !defaultValue.equals("CURRENT_TIMESTAMP") && !defaultValue.equals("CURRENT_TIME") && !defaultValue.equals("CURRENT_DATE");
            if (shouldUseQuotes) {
                this.print(this.getPlatformInfo().getValueQuoteToken());
                this.print(this.escapeStringValue(defaultValueStr));
                this.print(this.getPlatformInfo().getValueQuoteToken());
            } else {
                this.print(defaultValueStr);
            }
        }
    }
}

