/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddlutils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ddlutils.Platform;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ddlutils.firebird.FirebirdPlatform;
import org.jumpmind.symmetric.ddlutils.h2.H2Platform;
import org.jumpmind.symmetric.ddlutils.mssql.MsSqlPlatform;
import org.jumpmind.symmetric.ddlutils.oracle.OraclePlatform;
import org.jumpmind.symmetric.ddlutils.sqlite.SqLitePlatform;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class PlatformFactory {
    static final ILog log = LogFactory.getLog(PlatformFactory.class);
    private static boolean initialized = false;

    public static Platform getPlatform(DataSource dataSource) {
        Platform pf;
        PlatformFactory.initPlatforms();
        String productName = PlatformFactory.getDbProductName(dataSource);
        int majorVersion = PlatformFactory.getDbMajorVersion(dataSource);
        String productString = productName;
        if (majorVersion > 0) {
            productString = productString + majorVersion;
        }
        if (productName.startsWith("DB2")) {
            productString = "DB2v8";
        }
        if ((pf = org.apache.ddlutils.PlatformFactory.createNewPlatformInstance((String)productString)) == null) {
            pf = org.apache.ddlutils.PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
        } else {
            pf.setDataSource(dataSource);
        }
        log.info("PlatformInUse", pf.getClass().getName());
        return pf;
    }

    public static String getDbProductName(DataSource dataSource) {
        return (String)new JdbcTemplate(dataSource).execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String doInConnection(Connection c) throws SQLException, DataAccessException {
                DatabaseMetaData metaData = c.getMetaData();
                return metaData.getDatabaseProductName();
            }
        });
    }

    public static String getDatabaseProductVersion(DataSource dataSource) {
        return (String)new JdbcTemplate(dataSource).execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String doInConnection(Connection c) throws SQLException, DataAccessException {
                DatabaseMetaData metaData = c.getMetaData();
                return metaData.getDatabaseProductVersion();
            }
        });
    }

    public static int getDbMajorVersion(DataSource dataSource) {
        return (Integer)new JdbcTemplate(dataSource).execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            public Integer doInConnection(Connection c) throws SQLException, DataAccessException {
                DatabaseMetaData metaData = c.getMetaData();
                try {
                    return metaData.getDatabaseMajorVersion();
                }
                catch (UnsupportedOperationException e) {
                    return 0;
                }
            }
        });
    }

    public static int getDbMinorVersion(DataSource dataSource) {
        return (Integer)new JdbcTemplate(dataSource).execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            public Integer doInConnection(Connection c) throws SQLException, DataAccessException {
                DatabaseMetaData metaData = c.getMetaData();
                try {
                    return metaData.getDatabaseMinorVersion();
                }
                catch (UnsupportedOperationException e) {
                    return 0;
                }
            }
        });
    }

    private static synchronized void initPlatforms() {
        if (!initialized) {
            org.apache.ddlutils.PlatformFactory.registerPlatform((String)"SQLite3", SqLitePlatform.class);
            org.apache.ddlutils.PlatformFactory.registerPlatform((String)"Firebird", FirebirdPlatform.class);
            org.apache.ddlutils.PlatformFactory.registerPlatform((String)"Oracle10", OraclePlatform.class);
            for (String name : H2Platform.DATABASENAMES) {
                org.apache.ddlutils.PlatformFactory.registerPlatform((String)name, H2Platform.class);
            }
            org.apache.ddlutils.PlatformFactory.registerPlatform((String)"MsSql", MsSqlPlatform.class);
            initialized = true;
        }
    }
}

